/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.backend;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.webapps.WebApp;
import com.dataiku.dip.webapps.backend.WebAppBackend;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class WebAppBackendsManager {
    private Map<String, ProjectPythonBackends> projects = new HashMap<String, ProjectPythonBackends>();
    private static Logger logger = Logger.getLogger((String)"dku.webapps.backends.manager");

    public WebAppBackendInstance.BackendState getState(WebApp webApp, boolean keepSensitiveInfo) throws Exception {
        if (!webApp.params.isBackendEnabled()) {
            return null;
        }
        return this.getState(webApp.projectKey, webApp.id, keepSensitiveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WebAppBackendInstance.BackendState getState(String projectKey, String webAppId, boolean keepSensitiveInfo) throws Exception {
        WebAppBackend backend;
        WebAppBackendsManager webAppBackendsManager = this;
        synchronized (webAppBackendsManager) {
            backend = this.getBackendOrNull(projectKey, webAppId);
        }
        if (backend == null) {
            return null;
        }
        return backend.getState(keepSensitiveInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse<WebAppBackendInstance.BackendState> onSave_NT(AuthCtx authCtx, WebApp webApp, JsonObject userVariables, boolean forceRestartBackend, boolean keepSensitiveInfo) throws Exception {
        WebAppBackend oldBackend;
        if (webApp.params.isBackendEnabled()) {
            WebAppBackend backend = this.getOrCreateBackend(webApp);
            logger.info((Object)("Setting running code for " + webApp.id));
            return backend.updateCurrentState(authCtx, webApp, userVariables, forceRestartBackend, keepSensitiveInfo);
        }
        WebAppBackendsManager webAppBackendsManager = this;
        synchronized (webAppBackendsManager) {
            oldBackend = this.getBackendOrNull(webApp.projectKey, webApp.id);
            this.removeBackend(webApp.projectKey, webApp.id);
        }
        if (oldBackend != null) {
            oldBackend.stop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FutureResponse<WebAppBackendInstance.BackendState> forceRestart_NT(AuthCtx authCtx, WebApp webApp, JsonObject userVariables, boolean keepSensitiveInfo) throws Exception {
        WebAppBackend oldBackend;
        if (webApp.params.isBackendEnabled()) {
            WebAppBackend backend = this.getOrCreateBackend(webApp);
            logger.info((Object)("Setting running code for " + webApp.id));
            try {
                return backend.stopAndStart(authCtx, webApp, userVariables, keepSensitiveInfo);
            }
            catch (Exception e) {
                WebAppBackendsManager webAppBackendsManager = this;
                synchronized (webAppBackendsManager) {
                    this.removeBackend(webApp.projectKey, webApp.id);
                }
                throw e;
            }
        }
        WebAppBackendsManager webAppBackendsManager = this;
        synchronized (webAppBackendsManager) {
            oldBackend = this.getBackendOrNull(webApp.projectKey, webApp.id);
            this.removeBackend(webApp.projectKey, webApp.id);
        }
        if (oldBackend != null) {
            oldBackend.stop();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stop_NT(String projectKey, String webAppId) throws Exception {
        WebAppBackend backend;
        WebAppBackendsManager webAppBackendsManager = this;
        synchronized (webAppBackendsManager) {
            backend = this.getBackendOrNull(projectKey, webAppId);
            this.removeBackend(projectKey, webAppId);
        }
        if (backend != null) {
            backend.stop();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> listRegisteredBackends(String projectKey) {
        HashSet webAppIds = Sets.newHashSet();
        WebAppBackendsManager webAppBackendsManager = this;
        synchronized (webAppBackendsManager) {
            if (this.projects.containsKey(projectKey)) {
                HashMap backends = Maps.newHashMap(this.projects.get((Object)projectKey).backends);
                for (Map.Entry b : backends.entrySet()) {
                    try {
                        WebAppBackendInstance.BackendState state = ((WebAppBackend)b.getValue()).getState(true);
                        if (!WebAppBackendsManager.isBackendAlive(state)) continue;
                        webAppIds.add((String)b.getKey());
                    }
                    catch (Exception e) {
                        logger.warn((Object)"Unable to check if backend is running", (Throwable)e);
                    }
                }
            }
        }
        return webAppIds;
    }

    public static boolean isBackendAlive(WebAppBackendInstance.BackendState state) {
        return state != null && state.futureInfo != null && state.futureInfo.alive;
    }

    public WebAppBackend getBackendOrNull(String projectKey, String webAppId) {
        if (!this.projects.containsKey(projectKey) || !this.projects.get((Object)projectKey).backends.containsKey(webAppId)) {
            return null;
        }
        return this.projects.get((Object)projectKey).backends.get(webAppId);
    }

    private void putBackend(String projectKey, String webAppId, WebAppBackend webAppPythonBackend) {
        if (!this.projects.containsKey(projectKey)) {
            this.projects.put(projectKey, new ProjectPythonBackends());
        }
        logger.info((Object)("Add to running webapp backends list: " + projectKey + "." + webAppId));
        this.projects.get((Object)projectKey).backends.put(webAppId, webAppPythonBackend);
    }

    public void removeBackend(String projectKey, String webAppId) {
        if (this.projects.containsKey(projectKey) && this.projects.get((Object)projectKey).backends.containsKey(webAppId)) {
            logger.info((Object)("Remove from running webapp backends list: " + projectKey + "." + webAppId));
            this.projects.get((Object)projectKey).backends.remove(webAppId);
        }
    }

    @Nonnull
    public synchronized WebAppBackend getOrCreateBackend(WebApp webApp) {
        WebAppBackend backend = this.getBackendOrNull(webApp.projectKey, webApp.id);
        if (backend == null) {
            backend = new WebAppBackend(webApp);
            this.putBackend(webApp.projectKey, webApp.id, backend);
        }
        return backend;
    }

    public static class ProjectPythonBackends {
        Map<String, WebAppBackend> backends = new HashMap<String, WebAppBackend>();
    }
}

