/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.proxy;

import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.webapps.WebAppTemplateDesc;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.proxy.VirtualWebappRunner;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import com.google.gson.JsonObject;
import java.util.Map;

public class VirtualWebappRunnerBuilder {
    private final AuthCtx authCtx;
    private String projectKey;
    private String webappId;
    private WebAppTemplateDesc templateDesc;
    private StandardWebAppMeta.StandardWebAppParams params;
    private String name;
    private float aliveMins;
    private Map<String, String> envParams;
    private JsonObject config;
    private boolean keepSensitiveInfo;

    public VirtualWebappRunnerBuilder(AuthCtx u) {
        this.authCtx = u;
    }

    public VirtualWebappRunnerBuilder withProjectKey(String projectKey) {
        this.projectKey = projectKey;
        return this;
    }

    public VirtualWebappRunnerBuilder withWebappId(String webappId) {
        this.webappId = webappId;
        return this;
    }

    public VirtualWebappRunnerBuilder withTemplateDesc(WebAppTemplateDesc templateDesc) {
        this.templateDesc = templateDesc;
        return this;
    }

    public VirtualWebappRunnerBuilder withWebappParams(StandardWebAppMeta.StandardWebAppParams params) {
        this.params = params;
        return this;
    }

    public VirtualWebappRunnerBuilder withName(String name) {
        this.name = name;
        return this;
    }

    public VirtualWebappRunnerBuilder withAliveMins(float aliveMins) {
        this.aliveMins = aliveMins;
        return this;
    }

    public VirtualWebappRunnerBuilder withEnvParams(Map<String, String> envParams) {
        this.envParams = envParams;
        return this;
    }

    public VirtualWebappRunnerBuilder withConfig(JsonObject config) {
        this.config = config;
        return this;
    }

    public VirtualWebappRunnerBuilder withKeepSensitiveInfo(boolean keepSensitiveInfo) {
        this.keepSensitiveInfo = keepSensitiveInfo;
        return this;
    }

    public FutureResponse<WebAppBackendInstance.BackendState> startWebappIfNotRunning() throws Exception {
        VirtualWebappRunner virtualWebappRunner = new VirtualWebappRunner();
        virtualWebappRunner.authCtx = this.authCtx;
        virtualWebappRunner.projectKey = this.projectKey;
        virtualWebappRunner.webappId = this.webappId;
        virtualWebappRunner.templateDesc = this.templateDesc;
        virtualWebappRunner.params = this.params;
        virtualWebappRunner.name = this.name;
        virtualWebappRunner.aliveMins = this.aliveMins;
        virtualWebappRunner.envParams = this.envParams;
        virtualWebappRunner.config = this.config;
        virtualWebappRunner.keepSensitiveInfo = this.keepSensitiveInfo;
        return virtualWebappRunner.startWebappIfNotRunning();
    }
}

