/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dip.webapps.tensorboard;

import com.dataiku.dip.analysis.coreservices.AnalysisCRUDService;
import com.dataiku.dip.analysis.ml.MLTaskLoc;
import com.dataiku.dip.code.CodeEnvSelection;
import com.dataiku.dip.containers.exec.ContainerExecSelection;
import com.dataiku.dip.futures.FutureResponse;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.impersonation.FilesystemACLUtils;
import com.dataiku.dip.server.samples.SnippetOrigin;
import com.dataiku.dip.server.services.TransactionService;
import com.dataiku.dip.transactions.ifaces.Transaction;
import com.dataiku.dip.webapps.WebAppTemplateDesc;
import com.dataiku.dip.webapps.backend.WebAppBackendInstance;
import com.dataiku.dip.webapps.proxy.VirtualWebappRunnerBuilder;
import com.dataiku.dip.webapps.standard.StandardWebAppMeta;
import java.util.HashMap;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TensorBoardService {
    public static final float TENSORBOARD_ALIVE_MINS = 10.0f;
    @Autowired
    private AnalysisCRUDService analysisCRUDService;
    @Autowired
    private TransactionService transactionService;

    public FutureResponse<WebAppBackendInstance.BackendState> startTensorboardIfNotRunning(MLTaskLoc loc, String sessionId, AuthCtx u, boolean keepSensitiveInfo) throws Exception {
        CodeEnvSelection envSelection;
        assert (loc.analysisProjectKey != null);
        assert (loc.analysisId != null);
        assert (loc.mlTaskId != null);
        assert (sessionId != null);
        String webappId = "TENSORBOARD_" + TensorBoardService.createSessionWebAppId(loc.analysisProjectKey, loc.analysisId, loc.mlTaskId, sessionId);
        WebAppTemplateDesc templateDesc = new WebAppTemplateDesc();
        templateDesc.id = "tensorboard";
        templateDesc.type = "PROXY";
        templateDesc.origin = SnippetOrigin.BUILTIN;
        StandardWebAppMeta.StandardWebAppParams params = new StandardWebAppMeta.StandardWebAppParams();
        params.backendEnabled = true;
        String name = String.format("Tensorboard %s", webappId);
        HashMap<String, String> envParams = new HashMap<String, String>();
        envParams.put("analysisId", loc.analysisId);
        envParams.put("sessionId", sessionId);
        envParams.put("taskId", loc.mlTaskId);
        envParams.put("webappId", webappId);
        try (Transaction t = this.transactionService.beginRead();){
            envSelection = this.analysisCRUDService.getPMLTask((MLTaskLoc)loc).envSelection;
        }
        params.envSelection = envSelection;
        params.infra.containerSelection.containerMode = ContainerExecSelection.ContainerExecMode.NONE;
        VirtualWebappRunnerBuilder virtualWebappRunnerBuilder = new VirtualWebappRunnerBuilder(u);
        FilesystemACLUtils.grantFSReadACLs(u, loc.analysisProjectKey, loc.getDataFolder());
        return virtualWebappRunnerBuilder.withProjectKey(loc.analysisProjectKey).withWebappId(webappId).withTemplateDesc(templateDesc).withWebappParams(params).withName(name).withAliveMins(10.0f).withEnvParams(envParams).withKeepSensitiveInfo(keepSensitiveInfo).startWebappIfNotRunning();
    }

    public static String createSessionWebAppId(String projectKey, String analysisId, String taskId, String sessionId) {
        return String.format("%s-%s-%s-%s", projectKey, analysisId, taskId, sessionId);
    }
}

