/*
 * Decompiled with CFR 0.152.
 */
package com.google.refine.expr.functions.booleans;

import com.google.refine.expr.EvalError;
import com.google.refine.grel.Documentation;
import com.google.refine.grel.Example;
import com.google.refine.grel.Function;
import com.google.refine.grel.GrelControlFunctionRegistry;
import java.util.Properties;

public class Not
implements Function {
    @Override
    public Object call(Properties bindings, Object[] args) {
        if (args.length == 1) {
            if (args[0] == null) {
                return null;
            }
            return !Not.objectToBoolean(args[0]);
        }
        return new EvalError(GrelControlFunctionRegistry.getInstance().getFunctionName(this) + " expects a boolean");
    }

    public static boolean objectToBoolean(Object o) {
        return o != null && (o instanceof Boolean ? (Boolean)o != false : Boolean.parseBoolean(o.toString()));
    }

    @Override
    public Documentation getDocumentation() {
        return new Documentation("GREL.FUNCTION.Not.DOCUMENTATION", "Evaluates logical NOT (negation) of a statement, returning the opposite of <code>b</code>.").withParams("boolean b").withReturns("boolean").withCategory("GREL.FUNCTIONS.CATEGORY.BOOLEAN", "Boolean functions").withExample(Example.with("1!=1").returns("false"));
    }
}

