/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog;

import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.core.ApiClient;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.CreateRegisteredModelRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.DeleteAliasRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.DeleteRegisteredModelRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.GetRegisteredModelRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListRegisteredModelsRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.ListRegisteredModelsResponse;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.RegisteredModelAlias;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.RegisteredModelInfo;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.RegisteredModelsImpl;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.RegisteredModelsService;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.SetRegisteredModelAliasRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.service.catalog.UpdateRegisteredModelRequest;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Generated;
import com.dataiku.dss.shadelibdatabricks.com.databricks.sdk.support.Paginator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Generated
public class RegisteredModelsAPI {
    private static final Logger LOG = LoggerFactory.getLogger(RegisteredModelsAPI.class);
    private final RegisteredModelsService impl;

    public RegisteredModelsAPI(ApiClient apiClient) {
        this.impl = new RegisteredModelsImpl(apiClient);
    }

    public RegisteredModelsAPI(RegisteredModelsService mock) {
        this.impl = mock;
    }

    public RegisteredModelInfo create(String catalogName, String schemaName, String name) {
        return this.create(new CreateRegisteredModelRequest().setCatalogName(catalogName).setSchemaName(schemaName).setName(name));
    }

    public RegisteredModelInfo create(CreateRegisteredModelRequest request) {
        return this.impl.create(request);
    }

    public void delete(String fullName) {
        this.delete(new DeleteRegisteredModelRequest().setFullName(fullName));
    }

    public void delete(DeleteRegisteredModelRequest request) {
        this.impl.delete(request);
    }

    public void deleteAlias(String fullName, String alias) {
        this.deleteAlias(new DeleteAliasRequest().setFullName(fullName).setAlias(alias));
    }

    public void deleteAlias(DeleteAliasRequest request) {
        this.impl.deleteAlias(request);
    }

    public RegisteredModelInfo get(String fullName) {
        return this.get(new GetRegisteredModelRequest().setFullName(fullName));
    }

    public RegisteredModelInfo get(GetRegisteredModelRequest request) {
        return this.impl.get(request);
    }

    public Iterable<RegisteredModelInfo> list(ListRegisteredModelsRequest request) {
        return new Paginator(request, this.impl::list, ListRegisteredModelsResponse::getRegisteredModels, response -> {
            String token = response.getNextPageToken();
            if (token == null || token.isEmpty()) {
                return null;
            }
            return request.setPageToken(token);
        });
    }

    public RegisteredModelAlias setAlias(String fullName, String alias, long versionNum) {
        return this.setAlias(new SetRegisteredModelAliasRequest().setFullName(fullName).setAlias(alias).setVersionNum(versionNum));
    }

    public RegisteredModelAlias setAlias(SetRegisteredModelAliasRequest request) {
        return this.impl.setAlias(request);
    }

    public RegisteredModelInfo update(String fullName) {
        return this.update(new UpdateRegisteredModelRequest().setFullName(fullName));
    }

    public RegisteredModelInfo update(UpdateRegisteredModelRequest request) {
        return this.impl.update(request);
    }

    public RegisteredModelsService impl() {
        return this.impl;
    }
}

