/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.cli;

import com.dataiku.dip.server.SpringUtils;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.GHSpring;
import com.dataiku.gh.cli.CLICommand;
import com.dataiku.gh.cli.DKU;
import com.dataiku.gh.core.services.admin.IMigrationService;
import com.dataiku.gh.core.storage.admin.IDBDumpDAO;
import com.dataiku.gh.core.storage.sql.admin.DBDumpDAO;
import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.springframework.transaction.PlatformTransactionManager;

public class ReloadDBCommand
extends CLICommand {
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.cli.govern-reload-db");
    public static final String COMMAND_NAME = "__reload-db";

    @Override
    public String usageString() {
        return "__reload-db -s SOURCE_DIR [options]";
    }

    @Override
    public String description() {
        return "Reload the database";
    }

    @Override
    public Options opts() {
        Options options = new Options();
        DKU.addGlobalOptions(options);
        Option sourceDir = Option.builder((String)"s").longOpt("source").hasArg(true).argName("SOURCE_DIR").desc("Source directory where dump is located").build();
        Option excludeHistory = Option.builder((String)"e").longOpt("exclude-history").hasArg(false).desc("Exclude history tables").build();
        Option noDiagDb = Option.builder().longOpt("no-diagdb").hasArg(false).desc("Disable diagnostic DB tagging (enabled by default)").build();
        options.addOption(sourceDir);
        options.addOption(excludeHistory);
        options.addOption(noDiagDb);
        return options;
    }

    @Override
    public int execute(String[] args) throws Exception {
        CommandLine cmdLine = this.parseAndMiniSetup(args, COMMAND_NAME, true);
        if (!cmdLine.hasOption("s")) {
            return this.usage(1, "Missing SOURCE_DIR argument");
        }
        String sourceDirValue = cmdLine.getOptionValue("s");
        boolean excludeHistory = cmdLine.hasOption("e");
        boolean noDiagDb = cmdLine.hasOption("no-diagdb");
        File sourceDirFile = new File(sourceDirValue);
        GHSpring.doCLISetupWithDB();
        IMigrationService migrationService = (IMigrationService)SpringUtils.getBean(IMigrationService.class);
        PlatformTransactionManager transactionManager = (PlatformTransactionManager)SpringUtils.getBean(PlatformTransactionManager.class);
        migrationService.checkNoneVersion();
        Long dumpVersion = DBDumpDAO.getDumpVersion(sourceDirFile);
        migrationService.migrateToVersion(dumpVersion, transactionManager);
        logger.info((Object)("migrated db to version: " + dumpVersion));
        IDBDumpDAO dbDumpDAO = (IDBDumpDAO)SpringUtils.getBean(IDBDumpDAO.class);
        dbDumpDAO.reloadDB(sourceDirFile, excludeHistory, noDiagDb);
        return 0;
    }
}

