/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.models.subscriptions;

import com.dataiku.gh.core.models.subscriptions.SubscriptionId;
import com.dataiku.gh.core.visitors.ISubscriptionVisitor;
import com.dataiku.j2ts.annotations.UIModel;

@UIModel
public class Subscription {
    public SubscriptionId subscriptionId;
    public SubscriptionLevel subscriptionLevel = SubscriptionLevel.INO;

    public static Subscription buildSubscription(SubscriptionId subscriptionId, SubscriptionLevel subscriptionLevel) {
        Subscription subscription = new Subscription();
        subscription.subscriptionId = subscriptionId;
        subscription.subscriptionLevel = subscriptionLevel;
        return subscription;
    }

    public static Subscription buildSubscription(String artifactId, String userLogin, SubscriptionLevel subscriptionLevel) {
        return Subscription.buildSubscription(SubscriptionId.build(artifactId, userLogin), subscriptionLevel);
    }

    public String getArtifactId() {
        return this.subscriptionId.artifactId;
    }

    public SubscriptionLevel getSubscriptionLevel() {
        return this.subscriptionLevel;
    }

    public void accept(ISubscriptionVisitor visitor) {
        visitor.visit(this);
    }

    public static enum SubscriptionLevel {
        INO,
        ENO,
        YES,
        FULL;

    }
}

