/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.dss.status;

import com.dataiku.dip.directory.NodesDirectory;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.DSSItemGovernanceStatusList;
import com.dataiku.dss_gh.api.models.governance_status.GovernanceComment;
import com.dataiku.dss_gh.api.models.governance_status.GovernanceStatus;
import com.dataiku.dss_gh.api.models.governance_status.ProductionStatus;
import com.dataiku.dss_gh.api.models.governance_status.ValidationStatus;
import com.dataiku.dss_gh.api.models.identifiers.DSSBundleIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSDatasetIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSItemIdentifierList;
import com.dataiku.dss_gh.api.models.identifiers.DSSProjectIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSRetrievableKnowledgeIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelIdentifier;
import com.dataiku.dss_gh.api.models.identifiers.DSSSavedModelVersionIdentifier;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.artifacts.ArtifactWorkflowStep;
import com.dataiku.gh.core.models.blueprints.StepDefinition;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactWithoutPermissions;
import com.dataiku.gh.core.models.signoff.Signoff;
import com.dataiku.gh.core.models.signoff.SignoffApproval;
import com.dataiku.gh.core.models.system.SystemProvidedEnrichedBlueprint;
import com.dataiku.gh.core.models.ui.UIArtifact;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.dss.search_artifacts.IDSSIntegrationSearchArtifactsService;
import com.dataiku.gh.core.services.dss.status.IDSSIntegrationStatusService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.directory.NodesDirectoryService;
import com.dataiku.gh.security.IPermissionsService;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DSSIntegrationStatusService
implements IDSSIntegrationStatusService {
    @Autowired
    private IDSSIntegrationSearchArtifactsService dssIntegrationArtifactService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private NodesDirectoryService nodesDirectoryService;
    @Autowired
    private GeneralSettingsDAO generalSettingsDAO;
    @Autowired
    private IPermissionsService permissionsService;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.dss-integration-status");

    @Override
    @GHReadonlyTransaction
    public DSSItemGovernanceStatusList getGovernanceStatusList(AuthCtx authCtx, DSSItemIdentifierList dssItemIdentifierList) throws IOException, UnauthorizedException {
        this.permissionsService.checkAdmin(authCtx);
        DSSItemGovernanceStatusList dssItemGovernanceStatusList = new DSSItemGovernanceStatusList();
        for (DSSItemIdentifier dssItemIdentifier : dssItemIdentifierList.dssItemItentifiers) {
            Artifact existingArtifact;
            if (dssItemIdentifier instanceof DSSSavedModelVersionIdentifier) {
                existingArtifact = this.dssIntegrationArtifactService.findDSSSavedModelVersionArtifact((DSSSavedModelVersionIdentifier)dssItemIdentifier);
            } else if (dssItemIdentifier instanceof DSSSavedModelIdentifier) {
                existingArtifact = this.dssIntegrationArtifactService.findDSSSavedModelArtifact((DSSSavedModelIdentifier)dssItemIdentifier);
            } else if (dssItemIdentifier instanceof DSSRetrievableKnowledgeIdentifier) {
                existingArtifact = this.dssIntegrationArtifactService.findDSSRetrievableKnowledgeArtifact((DSSRetrievableKnowledgeIdentifier)dssItemIdentifier);
            } else if (dssItemIdentifier instanceof DSSDatasetIdentifier) {
                existingArtifact = this.dssIntegrationArtifactService.findDSSDatasetArtifact((DSSDatasetIdentifier)dssItemIdentifier);
            } else if (dssItemIdentifier instanceof DSSBundleIdentifier) {
                existingArtifact = this.dssIntegrationArtifactService.findDSSBundleArtifact((DSSBundleIdentifier)dssItemIdentifier);
            } else if (dssItemIdentifier instanceof DSSProjectIdentifier) {
                existingArtifact = this.dssIntegrationArtifactService.findDSSProjectArtifact((DSSProjectIdentifier)dssItemIdentifier);
            } else {
                throw new Error("Unreachable");
            }
            DSSItemGovernanceStatus dssItemGovernanceStatus = new DSSItemGovernanceStatus();
            dssItemGovernanceStatus.dssItemIdentifier = dssItemIdentifier;
            dssItemGovernanceStatus.governanceStatus = this.computeGovernanceStatus(existingArtifact);
            dssItemGovernanceStatusList.dssItemGovernanceStatuses.add(dssItemGovernanceStatus);
        }
        return dssItemGovernanceStatusList;
    }

    @Override
    public void setDataikuLinkToUIArtifact(UIArtifact uiArtifact, EnrichedArtifactWithoutPermissions enrichedArtifact) throws IOException {
        SystemProvidedEnrichedBlueprint speb = SystemProvidedConstants.SYSTEM_BLUEPRINT_BY_ID.get(enrichedArtifact.blueprint.id);
        if (speb == null || !SystemProvidedConstants.DATAIKU_PROJECT_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(enrichedArtifact.blueprint.id) && !SystemProvidedConstants.DEPLOYER_ITEMS_SYSTEM_BLUEPRINT_BY_ID.containsKey(enrichedArtifact.blueprint.id)) {
            return;
        }
        String nodeId = this.getFieldValueAsString(enrichedArtifact, "node_id");
        if (StringUtils.isBlank((CharSequence)nodeId)) {
            return;
        }
        String baseUrl = null;
        NodesDirectory nodesDirectory = this.nodesDirectoryService.getNodesDirectoryUnsafe_AutoTXN();
        if (nodesDirectory.enabled) {
            Optional nodeRefOptional = nodesDirectory.getById(nodeId);
            if (!nodeRefOptional.isPresent()) {
                logger.error((Object)("Node id not found in directory: " + nodeId));
            } else {
                NodesDirectory.NodeRef n = (NodesDirectory.NodeRef)nodeRefOptional.get();
                String string = baseUrl = StringUtils.isNotBlank((CharSequence)n.externalUrl) ? n.externalUrl : n.url;
            }
        }
        if (StringUtils.isBlank(baseUrl)) {
            GeneralSettingsDAO.GeneralSettings gs = this.generalSettingsDAO.getUnsafeAutoTXN();
            Optional<GeneralSettingsDAO.FallbackNodeRef> fallbackNodeRefOptional = gs.fallbackNodeRefs.stream().filter(fnr -> StringUtils.equals((CharSequence)fnr.nodeId, (CharSequence)nodeId)).findFirst();
            if (!fallbackNodeRefOptional.isPresent()) {
                logger.error((Object)("Node id not found in fallback node refs: " + nodeId));
                return;
            }
            baseUrl = fallbackNodeRefOptional.get().url;
        }
        if (StringUtils.isBlank(baseUrl)) {
            return;
        }
        String dataikuLink = baseUrl + (baseUrl.endsWith("/") ? "" : "/");
        if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.DATAIKU_PROJECT.blueprintId)) {
            Object e;
            List folderIdsList;
            projectKey = this.getFieldValueAsString(enrichedArtifact, "project_key");
            if (StringUtils.isBlank((CharSequence)projectKey)) {
                return;
            }
            dataikuLink = dataikuLink + "projects/" + projectKey + "/";
            Object fieldValue = enrichedArtifact.artifact.fields.get("project_location_folder_ids");
            if (fieldValue instanceof List && !(folderIdsList = (List)fieldValue).isEmpty() && (e = folderIdsList.get(0)) instanceof String) {
                String folderId = (String)e;
                uiArtifact.uiArtifactDetails.dataikuFolderLink = baseUrl + (baseUrl.endsWith("/") ? "" : "/") + "home/projects/" + folderId;
            }
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.DATAIKU_BUNDLE.blueprintId)) {
            projectKey = this.getFieldValueAsString(enrichedArtifact, "project_key");
            String bundleId = this.getFieldValueAsString(enrichedArtifact, "bundle_id");
            if (StringUtils.isBlank((CharSequence)projectKey) || StringUtils.isBlank((CharSequence)bundleId)) {
                return;
            }
            dataikuLink = dataikuLink + "projects/" + projectKey + "/bundles-design/?bundleId=" + bundleId;
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.DATAIKU_DATASET.blueprintId)) {
            projectKey = this.getFieldValueAsString(enrichedArtifact, "project_key");
            String datasetName = this.getFieldValueAsString(enrichedArtifact, "dataset_name");
            if (StringUtils.isBlank((CharSequence)projectKey) || StringUtils.isBlank((CharSequence)datasetName)) {
                return;
            }
            dataikuLink = dataikuLink + "projects/" + projectKey + "/datasets/" + datasetName + "/explore/";
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.DATAIKU_SAVED_MODEL.blueprintId)) {
            projectKey = this.getFieldValueAsString(enrichedArtifact, "project_key");
            String savedModelId = this.getFieldValueAsString(enrichedArtifact, "saved_model_id");
            if (StringUtils.isBlank((CharSequence)projectKey) || StringUtils.isBlank((CharSequence)savedModelId)) {
                return;
            }
            dataikuLink = dataikuLink + "projects/" + projectKey + "/savedmodels/" + savedModelId + "/versions/";
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.DATAIKU_RETRIEVABLE_KNOWLEDGE.blueprintId)) {
            projectKey = this.getFieldValueAsString(enrichedArtifact, "project_key");
            String retrievableKnowledgeId = this.getFieldValueAsString(enrichedArtifact, "retrievable_knowledge_id");
            if (StringUtils.isBlank((CharSequence)projectKey) || StringUtils.isBlank((CharSequence)retrievableKnowledgeId)) {
                return;
            }
            dataikuLink = dataikuLink + "projects/" + projectKey + "/knowledge-bank/" + retrievableKnowledgeId + "/usage/";
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.DATAIKU_SAVED_MODEL_VERSION.blueprintId)) {
            String modelType;
            projectKey = this.getFieldValueAsString(enrichedArtifact, "project_key");
            String savedModelId = this.getFieldValueAsString(enrichedArtifact, "saved_model_id");
            String fullModelId = this.getFieldValueAsString(enrichedArtifact, "full_model_version_id");
            if (StringUtils.isBlank((CharSequence)projectKey) || StringUtils.isBlank((CharSequence)savedModelId) || StringUtils.isBlank((CharSequence)fullModelId)) {
                return;
            }
            switch (enrichedArtifact.blueprintVersion.id.versionId) {
                case "bv.system.prediction": {
                    modelType = "p";
                    break;
                }
                case "bv.system.clustering": {
                    modelType = "c";
                    break;
                }
                case "bv.system.fine_tuning": {
                    modelType = "llm-generic";
                    break;
                }
                case "bv.system.agent": {
                    modelType = "agent";
                    break;
                }
                case "bv.system.augmented": {
                    modelType = "retrieval-augmented-llm";
                    break;
                }
                default: {
                    logger.warn((Object)("Cannot generate the Dataiku link for saved model version, unknown blueprint version: " + enrichedArtifact.blueprintVersion.id.versionId));
                    return;
                }
            }
            dataikuLink = dataikuLink + "projects/" + projectKey + "/savedmodels/" + savedModelId + "/" + modelType + "/" + fullModelId;
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.PROJECT_DEPLOYER_INFRA.blueprintId)) {
            infraID = this.getFieldValueAsString(enrichedArtifact, "infrastructure_id");
            if (StringUtils.isBlank((CharSequence)infraID)) {
                return;
            }
            dataikuLink = dataikuLink + "project-deployer/infras/" + infraID + "/";
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.API_DEPLOYER_INFRA.blueprintId)) {
            infraID = this.getFieldValueAsString(enrichedArtifact, "infrastructure_id");
            if (StringUtils.isBlank((CharSequence)infraID)) {
                return;
            }
            dataikuLink = dataikuLink + "api-deployer/infras/" + infraID + "/";
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.PROJECT_DEPLOYER_DEPLOYMENT.blueprintId)) {
            deploymentID = this.getFieldValueAsString(enrichedArtifact, "deployment_id");
            if (StringUtils.isBlank((CharSequence)deploymentID)) {
                return;
            }
            dataikuLink = dataikuLink + "project-deployer/deployments/" + deploymentID + "/";
        } else if (StringUtils.equals((CharSequence)enrichedArtifact.blueprintVersion.id.blueprintId, (CharSequence)SystemProvidedConstants.API_DEPLOYER_DEPLOYMENT.blueprintId)) {
            deploymentID = this.getFieldValueAsString(enrichedArtifact, "deployment_id");
            if (StringUtils.isBlank((CharSequence)deploymentID)) {
                return;
            }
            dataikuLink = dataikuLink + "api-deployer/deployments/" + deploymentID + "/";
        }
        uiArtifact.uiArtifactDetails.dataikuLink = dataikuLink;
    }

    private GovernanceStatus computeGovernanceStatus(@Nullable Artifact dssItemArtifact) throws IOException {
        GovernanceStatus governanceStatus = new GovernanceStatus();
        if (dssItemArtifact == null) {
            governanceStatus.synced = false;
            governanceStatus.governed = false;
            governanceStatus.validationStatus = ValidationStatus.NOT_APPLICABLE;
            governanceStatus.productionStatus = ProductionStatus.NOT_APPLICABLE;
        } else {
            governanceStatus.governArtifactName = dssItemArtifact.name;
            governanceStatus.synced = true;
            Object governedBy = dssItemArtifact.fields.get("governed_by");
            if (governedBy == null || StringUtils.isBlank((CharSequence)((String)governedBy))) {
                governanceStatus.governed = false;
                governanceStatus.governArtifactId = dssItemArtifact.id;
                governanceStatus.validationStatus = ValidationStatus.NOT_APPLICABLE;
                governanceStatus.productionStatus = ProductionStatus.NOT_APPLICABLE;
            } else {
                int productionStepIndex;
                int currentStepIndex;
                governanceStatus.governed = true;
                EnrichedArtifact ghItemArtifact = this.artifactsDataService.getArtifact((String)governedBy);
                List<StepDefinition> stepDefinitions = ghItemArtifact.blueprintVersion.workflowDefinition.stepDefinitions;
                governanceStatus.governArtifactId = ghItemArtifact.artifact.id;
                governanceStatus.governanceTemplateName = StringUtils.equals((CharSequence)ghItemArtifact.blueprintVersion.id.versionId, (CharSequence)"bv.system.default") ? "Dataiku Standard" : ghItemArtifact.blueprintVersion.name;
                String currentStepId = ghItemArtifact.getCurrentOngoingWorkflowStepId() != null ? ghItemArtifact.getCurrentOngoingWorkflowStepId() : ghItemArtifact.getFurthestFinishedStepId();
                OptionalInt currentStepIndexOpt = IntStream.range(0, stepDefinitions.size()).filter(i -> StringUtils.isNotBlank((CharSequence)currentStepId) && StringUtils.equals((CharSequence)currentStepId, (CharSequence)((StepDefinition)stepDefinitions.get((int)i)).id)).findFirst();
                OptionalInt validationStepIndexOpt = IntStream.range(0, stepDefinitions.size()).filter(i -> StringUtils.equals((CharSequence)"review", (CharSequence)((StepDefinition)stepDefinitions.get((int)i)).id)).findFirst();
                Optional<Signoff> validationStepSignoff = ghItemArtifact.findSignoffByStepId("review");
                if (currentStepIndexOpt.isPresent()) {
                    governanceStatus.currentStepName = stepDefinitions.get((int)currentStepIndexOpt.getAsInt()).name;
                }
                if (!validationStepIndexOpt.isPresent() || !currentStepIndexOpt.isPresent() && !StringUtils.isBlank((CharSequence)currentStepId)) {
                    governanceStatus.validationStatus = ValidationStatus.NOT_APPLICABLE;
                } else if (StringUtils.isBlank((CharSequence)currentStepId)) {
                    governanceStatus.validationStatus = ValidationStatus.NOT_VALIDATED;
                } else {
                    int validationStepIndex;
                    int currentStepIndex2 = currentStepIndexOpt.getAsInt();
                    if (currentStepIndex2 < (validationStepIndex = validationStepIndexOpt.getAsInt())) {
                        governanceStatus.validationStatus = ValidationStatus.NOT_VALIDATED;
                    } else if (currentStepIndex2 == validationStepIndex) {
                        ArtifactWorkflowStep validationWorkflowStep = ghItemArtifact.artifact.workflow.steps.get("review");
                        if (validationWorkflowStep != null && (validationWorkflowStep.isFinished() || validationWorkflowStep.isSkipped())) {
                            governanceStatus.validationStatus = ValidationStatus.APPROVED;
                        } else if (!validationStepSignoff.isPresent()) {
                            governanceStatus.validationStatus = ValidationStatus.IN_VALIDATION;
                        } else {
                            Optional<Signoff> rejectedSignoff = validationStepSignoff.filter(s -> s.status == Signoff.SignoffStatus.REJECTED);
                            Optional<Signoff> abandonedSignoff = validationStepSignoff.filter(s -> s.status == Signoff.SignoffStatus.ABANDONED);
                            boolean notApproved = validationStepSignoff.filter(s -> s.status != Signoff.SignoffStatus.APPROVED).isPresent();
                            if (rejectedSignoff.isPresent()) {
                                governanceStatus.validationStatus = ValidationStatus.REJECTED;
                                governanceStatus.governanceComments = this.buildGovernanceComments(rejectedSignoff, false);
                            } else if (abandonedSignoff.isPresent()) {
                                governanceStatus.validationStatus = ValidationStatus.ABANDONED;
                                governanceStatus.governanceComments = this.buildGovernanceComments(abandonedSignoff, false);
                            } else if (!notApproved) {
                                governanceStatus.validationStatus = ValidationStatus.APPROVED;
                                governanceStatus.governanceComments = this.buildGovernanceComments(validationStepSignoff, true);
                            } else {
                                governanceStatus.validationStatus = ValidationStatus.IN_VALIDATION;
                            }
                        }
                    } else {
                        governanceStatus.validationStatus = ValidationStatus.APPROVED;
                        governanceStatus.governanceComments = this.buildGovernanceComments(validationStepSignoff, true);
                    }
                }
                OptionalInt productionStepIndexOpt = IntStream.range(0, stepDefinitions.size()).filter(i -> "production".equals(((StepDefinition)stepDefinitions.get((int)i)).id)).findFirst();
                governanceStatus.productionStatus = !productionStepIndexOpt.isPresent() || !currentStepIndexOpt.isPresent() && !StringUtils.isBlank((CharSequence)currentStepId) ? ProductionStatus.NOT_APPLICABLE : (StringUtils.isBlank((CharSequence)currentStepId) ? ProductionStatus.NOT_IN_PRODUCTION : ((currentStepIndex = currentStepIndexOpt.getAsInt()) < (productionStepIndex = productionStepIndexOpt.getAsInt()) ? ProductionStatus.NOT_IN_PRODUCTION : (currentStepIndex == productionStepIndex ? ProductionStatus.IN_PRODUCTION : ProductionStatus.RETIRED)));
            }
        }
        return governanceStatus;
    }

    private List<GovernanceComment> buildGovernanceComments(Optional<Signoff> signoff, boolean onlyApprovedSignoff) {
        return signoff.filter(s -> !onlyApprovedSignoff || s.status == Signoff.SignoffStatus.APPROVED).map(s -> s.approverResponse).filter(approverResponse -> approverResponse != null && StringUtils.isNotBlank((CharSequence)approverResponse.comment)).map(approverResponse -> Lists.newArrayList((Object[])new GovernanceComment[]{this.buildGovernanceComment((SignoffApproval)approverResponse)})).orElse(Lists.newArrayList());
    }

    private GovernanceComment buildGovernanceComment(SignoffApproval signoffApproval) {
        GovernanceComment governanceComment = new GovernanceComment();
        governanceComment.comment = signoffApproval.comment;
        governanceComment.statusDate = Optional.ofNullable(signoffApproval.editionDate).orElse(signoffApproval.creationDate);
        governanceComment.user = signoffApproval.user;
        return governanceComment;
    }

    private String getFieldValueAsString(EnrichedArtifactWithoutPermissions enrichedArtifact, String fieldId) {
        Object fieldValue = enrichedArtifact.artifact.fields.get(fieldId);
        if (!(fieldValue instanceof String)) {
            logger.error((Object)("Field not found in Dataiku item: " + fieldId));
            return null;
        }
        return (String)fieldValue;
    }
}

