/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.import_export.configs;

import com.dataiku.gh.core.models.blueprints.BlueprintVersionExport;
import com.dataiku.gh.core.models.fields.FieldType;
import com.dataiku.gh.core.models.fields.definitions.FieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.StoredReferenceFieldDefinition;
import com.dataiku.gh.core.models.fields.definitions.types.reference.backreference.BackreferenceFieldDefinition;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12200;
import com.dataiku.gh.core.services.admin.migrations.MigrationV12400;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13300;
import com.dataiku.gh.core.services.admin.migrations.MigrationV13400;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14000;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14100;
import com.dataiku.gh.core.services.admin.migrations.MigrationV14300;
import com.dataiku.gh.core.services.admin.migrations.utils.MigrationJsonUtils;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.import_export.ExportedEntityMigrationService;
import com.dataiku.gh.core.services.import_export.IExportedEntityMigrationConfigService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BlueprintVersionMigrationConfigurationService
implements IExportedEntityMigrationConfigService {
    @Autowired
    IBlueprintsDataService blueprintDataService;

    @Override
    public Class<?> getTargetClass() {
        return BlueprintVersionExport.class;
    }

    @Override
    public Map<Long, ExportedEntityMigrationService.EntityMigration> getMigrationSteps() {
        return ImmutableMap.builder().put((Object)12200L, BlueprintVersionMigrationConfigurationService::migrateBlueprintVersionWithOriginVersionIdAndSignoffConfigurationsToV12200).put((Object)12400L, BlueprintVersionMigrationConfigurationService::migrateBlueprintVersionExportToV12400).put((Object)13300L, this::migrateBlueprintVersionExportToV13300).put((Object)13400L, BlueprintVersionMigrationConfigurationService::migrateBlueprintVersionExportToV13400).put((Object)14000L, BlueprintVersionMigrationConfigurationService::migrateBlueprintVersionExportToV14000).put((Object)14100L, BlueprintVersionMigrationConfigurationService::migrateBlueprintVersionExportToV14100).put((Object)14300L, BlueprintVersionMigrationConfigurationService::migrateBlueprintVersionExportToV14300).build();
    }

    protected static JsonObject migrateBlueprintVersionWithOriginVersionIdAndSignoffConfigurationsToV12200(JsonObject blueprintVersionWithOriginVersionIdAndSignoffConfigurations) {
        JsonObject blueprintVersionId = MigrationJsonUtils.getObjectSubpath((JsonElement)blueprintVersionWithOriginVersionIdAndSignoffConfigurations, "blueprintVersion", "id").orElse(null);
        JsonArray signoffConfigurationHolders = MigrationJsonUtils.getArraySubpath((JsonElement)blueprintVersionWithOriginVersionIdAndSignoffConfigurations, "signoffConfigurationHolders").orElse(new JsonArray());
        JsonArray signoffConfigurations = MigrationV12200.migrateSignoffConfigurationHoldersToSignoffConfigurations(blueprintVersionId, signoffConfigurationHolders);
        blueprintVersionWithOriginVersionIdAndSignoffConfigurations.remove("signoffConfigurationHolders");
        blueprintVersionWithOriginVersionIdAndSignoffConfigurations.add("signoffsConfigurations", (JsonElement)signoffConfigurations);
        return blueprintVersionWithOriginVersionIdAndSignoffConfigurations;
    }

    protected static JsonObject migrateBlueprintVersionExportToV12400(JsonObject ancestor) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)ancestor, "blueprintVersion").ifPresent(MigrationV12400::migrateReferenceViewComponentsFromBPV);
        return ancestor;
    }

    private JsonObject migrateBlueprintVersionExportToV13300(JsonObject ancestor) throws IOException {
        Map<String, MigrationV13300.BlueprintInfo> bpMapping = this.getBlueprintInfo();
        return BlueprintVersionMigrationConfigurationService.migrateBlueprintVersionExportToV13300(ancestor, bpMapping);
    }

    protected static JsonObject migrateBlueprintVersionExportToV13300(JsonObject ancestor, Map<String, MigrationV13300.BlueprintInfo> bpMapping) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)ancestor, "blueprintVersion").ifPresent(bpv -> MigrationV13300.migrateBpvViews(bpv, bpMapping));
        return ancestor;
    }

    protected Map<String, MigrationV13300.BlueprintInfo> getBlueprintInfo() throws IOException {
        HashMap<String, MigrationV13300.BlueprintInfo> blueprintInfoMap = new HashMap<String, MigrationV13300.BlueprintInfo>();
        this.blueprintDataService.listBlueprintVersions().forEach(ebpv -> {
            blueprintInfoMap.putIfAbsent(ebpv.blueprint.id, new MigrationV13300.BlueprintInfo());
            MigrationV13300.BlueprintInfo bpInfo = (MigrationV13300.BlueprintInfo)blueprintInfoMap.get(ebpv.blueprint.id);
            if (CollectionUtils.isNotEmpty(ebpv.blueprintVersion.workflowDefinition.stepDefinitions)) {
                bpInfo.displayWorkflow = true;
            }
            ebpv.blueprintVersion.uiDefinition.views.forEach((id, view) -> bpInfo.viewLabels.put((String)id, view.label));
            ebpv.blueprintVersion.fieldDefinitions.entrySet().stream().filter(entry -> ((FieldDefinition)entry.getValue()).fieldType.equals((Object)FieldType.REFERENCE)).forEach(entry -> {
                switch (((FieldDefinition)entry.getValue()).sourceType) {
                    case STORE: {
                        StoredReferenceFieldDefinition storeFieldDef = (StoredReferenceFieldDefinition)entry.getValue();
                        bpInfo.referencedBlueprints.putIfAbsent((String)entry.getKey(), new HashSet());
                        bpInfo.referencedBlueprints.get(entry.getKey()).addAll(storeFieldDef.allowedBlueprints);
                        break;
                    }
                    case COMPUTE: {
                        BackreferenceFieldDefinition computeFieldDef = (BackreferenceFieldDefinition)entry.getValue();
                        bpInfo.referencedBlueprints.putIfAbsent((String)entry.getKey(), new HashSet());
                        List referencedBlueprints = computeFieldDef.references.stream().map(fieldRef -> fieldRef.blueprintId).collect(Collectors.toList());
                        bpInfo.referencedBlueprints.get(entry.getKey()).addAll(referencedBlueprints);
                    }
                }
            });
        });
        return blueprintInfoMap;
    }

    protected static JsonObject migrateBlueprintVersionExportToV13400(JsonObject ancestor) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)ancestor, "blueprintVersion").ifPresent(MigrationV13400::migrateGovernModelVersionBPVsReferenceToParentToAllowGovernProject);
        return ancestor;
    }

    protected static JsonObject migrateBlueprintVersionExportToV14000(JsonObject ancestor) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)ancestor, "blueprintVersion").ifPresent(MigrationV14000::migrateGovernModelVersionBPVsReferenceToParentToRemoveGovernProject);
        return ancestor;
    }

    protected static JsonObject migrateBlueprintVersionExportToV14100(JsonObject ancestor) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)ancestor, "blueprintVersion").ifPresent(MigrationV14100::migrateBlueprintVersion);
        return ancestor;
    }

    protected static JsonObject migrateBlueprintVersionExportToV14300(JsonObject ancestor) {
        MigrationJsonUtils.getObjectSubpath((JsonElement)ancestor, "blueprintVersion").ifPresent(MigrationV14300::migrateBlueprintVersion);
        return ancestor;
    }
}

