/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions;

import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprint;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.models.enriched.EnrichedDeletedArtifact;
import com.dataiku.gh.core.models.roles.AssignedRolesAndPermissionsCtx;
import com.dataiku.gh.core.models.roles.audit.RolesAndPermissionsAudit;
import com.dataiku.gh.core.models.roles.permissions.EffectivePermissionsItem;
import com.dataiku.gh.core.services.artifacts.IArtifactHistoryAwareService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.roles_and_permissions.IRolesAndPermissionsService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUserBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.assigned_roles.IUsersAndAPIKeysBlueprintRoleAssignmentsComputationService;
import com.dataiku.gh.core.services.roles_and_permissions.computation.effective_permissions.IEffectivePermissionsComputationService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.utils.Either;
import com.dataiku.gh.security.AuthCtxCreationService;
import com.dataiku.gh.security.PermissionsService;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RolesAndPermissionsService
implements IRolesAndPermissionsService {
    @Autowired
    private IUserBlueprintRoleAssignmentsComputationService blueprintRoleAssignmentsComputationService;
    @Autowired
    private IUsersAndAPIKeysBlueprintRoleAssignmentsComputationService usersAndAPIKeysBlueprintRoleAssignmentsComputationService;
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactHistoryAwareService artifactHistoryAwareService;
    @Autowired
    private AuthCtxCreationService authCtxCreationService;
    @Autowired
    private PermissionsService permissionsService;
    @Autowired
    private IEffectivePermissionsComputationService effectivePermissionsComputationService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.roles-and-permissions");

    @Override
    @GHReadonlyTransaction
    public AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtBlueprintLevel(AuthCtx authCtx, EnrichedBlueprint enrichedBlueprint) throws IOException {
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtBlueprintLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedBlueprint);
        return this.computeAssignedRolesAndPermissionsCtxAtBlueprintLevelWithAudit(authCtx, enrichedBlueprint, rolesAndPermissionsAudit);
    }

    @Override
    @GHReadonlyTransaction
    public RolesAndPermissionsAudit auditAssignedRolesAndPermissionsCtxAtBlueprintLevel(String authIdentifier, String blueprintId) throws IOException, DKUSecurityException {
        AuthCtx userAuthCtx = this.authCtxCreationService.create_autoTxn(authIdentifier);
        EnrichedBlueprint enrichedBlueprint = this.blueprintsDataService.getBlueprint(blueprintId);
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtBlueprintLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithNoShortcuts(), enrichedBlueprint);
        this.computeAssignedRolesAndPermissionsCtxAtBlueprintLevelWithAudit(userAuthCtx, enrichedBlueprint, rolesAndPermissionsAudit);
        return rolesAndPermissionsAudit;
    }

    private AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtBlueprintLevelWithAudit(AuthCtx authCtx, EnrichedBlueprint enrichedBlueprint, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        Set<String> assignedRoles = this.blueprintRoleAssignmentsComputationService.computeRolesAtBlueprintLevel(authCtx, enrichedBlueprint, rolesAndPermissionsAudit.rolesAssignmentsAudit);
        EffectivePermissionsItem effectivePermissionsItem = this.effectivePermissionsComputationService.computeEffectivePermissionsAtBlueprintLevel(assignedRoles, this.permissionsService.isGovernArchitect(authCtx), SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(enrichedBlueprint.blueprint.id), true, enrichedBlueprint.blueprintPermissions, null, rolesAndPermissionsAudit.permissionsAudit);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = new AssignedRolesAndPermissionsCtx();
        assignedRolesAndPermissionsCtx.assignedRoles = assignedRoles;
        assignedRolesAndPermissionsCtx.effectivePermissionsItem = effectivePermissionsItem;
        rolesAndPermissionsAudit.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
        return assignedRolesAndPermissionsCtx;
    }

    @Override
    @GHReadonlyTransaction
    public AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(AuthCtx authCtx, EnrichedBlueprintVersion enrichedBlueprintVersion) throws IOException {
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtBlueprintVersionLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedBlueprintVersion);
        return this.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevelWithAudit(authCtx, enrichedBlueprintVersion, rolesAndPermissionsAudit);
    }

    @Override
    @GHReadonlyTransaction
    public RolesAndPermissionsAudit auditAssignedRolesAndPermissionsCtxAtBlueprintVersionLevel(String authIdentifier, BlueprintVersionId blueprintVersionId) throws IOException, DKUSecurityException {
        AuthCtx userAuthCtx = this.authCtxCreationService.create_autoTxn(authIdentifier);
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtBlueprintVersionLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithNoShortcuts(), enrichedBlueprintVersion);
        this.computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevelWithAudit(userAuthCtx, enrichedBlueprintVersion, rolesAndPermissionsAudit);
        return rolesAndPermissionsAudit;
    }

    private AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtBlueprintVersionLevelWithAudit(AuthCtx authCtx, EnrichedBlueprintVersion enrichedBlueprintVersion, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        Set<String> assignedRoles = this.blueprintRoleAssignmentsComputationService.computeRolesAtBlueprintVersionLevel(authCtx, enrichedBlueprintVersion, rolesAndPermissionsAudit.rolesAssignmentsAudit);
        EffectivePermissionsItem effectivePermissionsItem = this.effectivePermissionsComputationService.computeEffectivePermissionsAtBlueprintVersionLevel(assignedRoles, this.permissionsService.isGovernArchitect(authCtx), SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(enrichedBlueprintVersion.blueprint.id), true, enrichedBlueprintVersion.blueprintPermissions, enrichedBlueprintVersion.blueprintVersion, rolesAndPermissionsAudit.permissionsAudit);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = new AssignedRolesAndPermissionsCtx();
        assignedRolesAndPermissionsCtx.assignedRoles = assignedRoles;
        assignedRolesAndPermissionsCtx.effectivePermissionsItem = effectivePermissionsItem;
        rolesAndPermissionsAudit.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
        return assignedRolesAndPermissionsCtx;
    }

    @Override
    @GHReadonlyTransaction
    public AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(AuthCtx authCtx, EnrichedArtifact enrichedArtifact) throws IOException {
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtArtifactExistingLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedArtifact);
        return this.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevelWithAudit(authCtx, enrichedArtifact, rolesAndPermissionsAudit);
    }

    @Override
    @GHReadonlyTransaction
    public Map<String, EffectivePermissionsItem> computeAllUsersEffectivePermissionsItemAtExistingArtifactLevel(EnrichedArtifact enrichedArtifact, Map<String, Boolean> isGovernArchitect) throws IOException {
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtArtifactExistingLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedArtifact);
        return this.computeAllUsersEffectivePermissionsItemAtExistingArtifactLevelWithAudit(enrichedArtifact, isGovernArchitect, rolesAndPermissionsAudit);
    }

    private Map<String, EffectivePermissionsItem> computeAllUsersEffectivePermissionsItemAtExistingArtifactLevelWithAudit(EnrichedArtifact enrichedArtifact, Map<String, Boolean> isGovernArchitect, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        List<IUserBlueprintRoleAssignmentsComputationService.UserLoginsAndAPIKeyIdsForRole> assignedRoles = this.usersAndAPIKeysBlueprintRoleAssignmentsComputationService.computeUserLoginsAndAPIKeyIdsForRolesAtArtifactExistingLevel(enrichedArtifact, rolesAndPermissionsAudit);
        return this.effectivePermissionsComputationService.computeAllUsersEffectivePermissionsAtArtifactLevel(assignedRoles, isGovernArchitect, SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(enrichedArtifact.blueprint.id), true, enrichedArtifact.blueprintPermissions, enrichedArtifact.blueprintVersion, rolesAndPermissionsAudit);
    }

    @Override
    @GHReadonlyTransaction
    public RolesAndPermissionsAudit auditAssignedRolesAndPermissionsCtxAtExistingArtifactLevel(String authIdentifier, String artifactId) throws IOException, DKUSecurityException {
        AuthCtx userAuthCtx = this.authCtxCreationService.create_autoTxn(authIdentifier);
        EnrichedArtifact enrichedArtifact = this.artifactsDataService.getArtifact(artifactId);
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtArtifactExistingLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithNoShortcuts(), enrichedArtifact);
        this.computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevelWithAudit(userAuthCtx, enrichedArtifact, rolesAndPermissionsAudit);
        return rolesAndPermissionsAudit;
    }

    private AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtExistingArtifactLevelWithAudit(AuthCtx authCtx, EnrichedArtifact enrichedArtifact, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        Set<String> assignedRoles = this.blueprintRoleAssignmentsComputationService.computeRolesAtArtifactExistingLevel(authCtx, enrichedArtifact, rolesAndPermissionsAudit.rolesAssignmentsAudit);
        EffectivePermissionsItem effectivePermissionsItem = this.effectivePermissionsComputationService.computeEffectivePermissionsAtArtifactLevel(assignedRoles, this.permissionsService.isGovernArchitect(authCtx), SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(enrichedArtifact.blueprint.id), true, enrichedArtifact.blueprintPermissions, enrichedArtifact.blueprintVersion, rolesAndPermissionsAudit.permissionsAudit);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = new AssignedRolesAndPermissionsCtx();
        assignedRolesAndPermissionsCtx.assignedRoles = assignedRoles;
        assignedRolesAndPermissionsCtx.effectivePermissionsItem = effectivePermissionsItem;
        rolesAndPermissionsAudit.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
        return assignedRolesAndPermissionsCtx;
    }

    @Override
    @GHReadonlyTransaction
    public AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtArtifactDeletedLevel(AuthCtx authCtx, EnrichedDeletedArtifact enrichedDeletedArtifact) throws IOException {
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtArtifactDeletedLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithShortcuts(), enrichedDeletedArtifact);
        return this.computeAssignedRolesAndPermissionsCtxAtArtifactDeletedLevelWithAudit(authCtx, enrichedDeletedArtifact, rolesAndPermissionsAudit);
    }

    @Override
    @GHReadonlyTransaction
    public RolesAndPermissionsAudit auditAssignedRolesAndPermissionsCtxAtArtifactDeletedLevel(String authIdentifier, String artifactId) throws IOException, DKUSecurityException {
        AuthCtx userAuthCtx = this.authCtxCreationService.create_autoTxn(authIdentifier);
        Either<EnrichedArtifact, EnrichedDeletedArtifact> artifact = this.artifactHistoryAwareService.getHistoryAwareArtifact(artifactId);
        if (artifact.isLeft()) {
            throw new ValidationException("Artifact " + artifactId + " is not deleted");
        }
        EnrichedDeletedArtifact enrichedDeletedArtifact = artifact.getRight();
        RolesAndPermissionsAudit rolesAndPermissionsAudit = RolesAndPermissionsAudit.buildAtArtifactDeletedLevel(RolesAndPermissionsAudit.AuditConfiguration.buildWithNoShortcuts(), enrichedDeletedArtifact);
        this.computeAssignedRolesAndPermissionsCtxAtArtifactDeletedLevelWithAudit(userAuthCtx, enrichedDeletedArtifact, rolesAndPermissionsAudit);
        return rolesAndPermissionsAudit;
    }

    private AssignedRolesAndPermissionsCtx computeAssignedRolesAndPermissionsCtxAtArtifactDeletedLevelWithAudit(AuthCtx authCtx, EnrichedDeletedArtifact enrichedDeletedArtifact, RolesAndPermissionsAudit rolesAndPermissionsAudit) throws IOException {
        Set<String> assignedRoles = this.blueprintRoleAssignmentsComputationService.computeRolesAtArtifactDeletedLevel(authCtx, enrichedDeletedArtifact, rolesAndPermissionsAudit.rolesAssignmentsAudit);
        EffectivePermissionsItem effectivePermissionsItem = this.effectivePermissionsComputationService.computeEffectivePermissionsAtArtifactLevel(assignedRoles, this.permissionsService.isGovernArchitect(authCtx), SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(enrichedDeletedArtifact.lastKnownEnrichedArtifact.blueprint.id), enrichedDeletedArtifact.currentEnrichedBlueprint != null, enrichedDeletedArtifact.currentEnrichedBlueprint != null ? enrichedDeletedArtifact.currentEnrichedBlueprint.blueprintPermissions : null, enrichedDeletedArtifact.lastKnownEnrichedArtifact.blueprintVersion, rolesAndPermissionsAudit.permissionsAudit);
        AssignedRolesAndPermissionsCtx assignedRolesAndPermissionsCtx = new AssignedRolesAndPermissionsCtx();
        assignedRolesAndPermissionsCtx.assignedRoles = assignedRoles;
        assignedRolesAndPermissionsCtx.effectivePermissionsItem = effectivePermissionsItem;
        rolesAndPermissionsAudit.assignedRolesAndPermissionsCtx = assignedRolesAndPermissionsCtx;
        return assignedRolesAndPermissionsCtx;
    }
}

