/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.roles_and_permissions.assignments;

import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.gh.core.models.roles.assignments.BlueprintRoleAssignments;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IAdminBlueprintRoleAssignmentsService;
import com.dataiku.gh.core.services.roles_and_permissions.assignments.IBlueprintRoleAssignmentsDataService;
import com.dataiku.gh.core.services.utils.GHReadonlyTransaction;
import com.dataiku.gh.core.services.utils.GHWriteTransaction;
import com.dataiku.gh.core.services.validation.IRoleAssignmentsValidationService;
import com.dataiku.gh.security.IPermissionsService;
import java.io.IOException;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AdminBlueprintRoleAssignmentsService
implements IAdminBlueprintRoleAssignmentsService {
    @Autowired
    private IBlueprintRoleAssignmentsDataService blueprintRoleAssignmentsDataService;
    @Autowired
    private IRoleAssignmentsValidationService blueprintRoleAssignmentsValidationService;
    @Autowired
    private IPermissionsService permissionsService;
    private static final DKULogger logger = DKULogger.getLogger((String)"gh.services.blueprint-role-assignments");

    @Override
    @GHReadonlyTransaction
    public BlueprintRoleAssignments getBlueprintRoleAssignments(AuthCtx authCtx, String blueprintId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintRoleAssignmentsDataService.getBlueprintRoleAssignments(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public BlueprintRoleAssignments getBlueprintRoleAssignmentsOrNull(AuthCtx authCtx, String blueprintId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintRoleAssignmentsDataService.getBlueprintRoleAssignmentsOrNull(blueprintId);
    }

    @Override
    @GHReadonlyTransaction
    public List<BlueprintRoleAssignments> listBlueprintRoleAssignments(AuthCtx authCtx) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        return this.blueprintRoleAssignmentsDataService.listBlueprintRoleAssignments();
    }

    @Override
    @GHWriteTransaction
    public BlueprintRoleAssignments createBlueprintRoleAssignments(AuthCtx authCtx, BlueprintRoleAssignments blueprintRoleAssignments) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintRoleAssignmentsValidationService.validateBlueprintRoleAssignments(blueprintRoleAssignments);
        return this.blueprintRoleAssignmentsDataService.createBlueprintRoleAssignments(blueprintRoleAssignments);
    }

    @Override
    @GHWriteTransaction
    public BlueprintRoleAssignments saveBlueprintRoleAssignments(AuthCtx authCtx, BlueprintRoleAssignments blueprintRoleAssignments) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintRoleAssignmentsValidationService.validateBlueprintRoleAssignments(blueprintRoleAssignments);
        return this.blueprintRoleAssignmentsDataService.saveBlueprintRoleAssignments(blueprintRoleAssignments);
    }

    @Override
    @GHWriteTransaction
    public void deleteBlueprintRoleAssignments(AuthCtx authCtx, String blueprintId) throws IOException, UnauthorizedException {
        this.permissionsService.checkIsGovernArchitect(authCtx);
        this.blueprintRoleAssignmentsDataService.deleteBlueprintRoleAssignments(blueprintId);
    }
}

