/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.services.system;

import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.core.models.artifacts.Artifact;
import com.dataiku.gh.core.models.blueprints.BlueprintVersionId;
import com.dataiku.gh.core.models.enriched.EnrichedArtifact;
import com.dataiku.gh.core.models.enriched.EnrichedArtifactDetails;
import com.dataiku.gh.core.models.enriched.EnrichedBlueprintVersion;
import com.dataiku.gh.core.services.artifacts.IArtifactWorkflowService;
import com.dataiku.gh.core.services.artifacts.IArtifactsDataService;
import com.dataiku.gh.core.services.blueprints.IBlueprintsDataService;
import com.dataiku.gh.core.services.python_execution.IPythonExecutionService;
import com.dataiku.gh.core.services.python_execution.logical_hooks.HooksExecutionResult;
import com.dataiku.gh.core.services.signoff.SignoffUtils;
import com.dataiku.gh.core.services.system.ISystemArtifactService;
import com.dataiku.gh.core.services.system.SystemProvidedConstants;
import com.dataiku.gh.core.services.validation.errors.ValidationException;
import com.dataiku.gh.core.storage.artifacts.IArtifactIDDAO;
import com.dataiku.gh.core.utils.FunctionUtils;
import com.dataiku.gh.core.utils.IdentifiersUtils;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SystemArtifactService
implements ISystemArtifactService {
    @Autowired
    private IArtifactsDataService artifactsDataService;
    @Autowired
    private IBlueprintsDataService blueprintsDataService;
    @Autowired
    private IArtifactIDDAO artifactIDDAO;
    @Autowired
    private IArtifactWorkflowService artifactWorkflowService;
    @Autowired
    private IPythonExecutionService pythonExecutionService;

    @Override
    public EnrichedArtifact createSystemArtifact(BlueprintVersionId blueprintVersionId, Artifact artifact, @Nullable String authCtxIdentifier) throws IOException {
        if (artifact.id != null) {
            throw new ValidationException("Artifact ID `" + artifact.id + "` can't be set in creation");
        }
        return this.upsertPatchSystemArtifact(null, blueprintVersionId, ea -> {
            ea.artifact.fields = artifact.fields;
            ea.artifact.status = artifact.status;
            ea.artifact.name = artifact.name;
        }, authCtxIdentifier);
    }

    @Override
    public EnrichedArtifact updateSystemArtifact(Artifact artifact, @Nullable String authCtxIdentifier) throws IOException {
        return this.updateSystemArtifact(artifact.id, ea -> {
            ea.artifact = artifact;
        }, authCtxIdentifier);
    }

    @Override
    public EnrichedArtifact updateSystemArtifact(String existingArtifactId, FunctionUtils.ConsumerCanThrowsException<EnrichedArtifact, IOException> patch, @Nullable String authCtxIdentifier) throws IOException {
        if (existingArtifactId == null) {
            throw new ValidationException("Artifact id must be set to update");
        }
        EnrichedArtifact existingEnrichedArtifact = this.artifactsDataService.getArtifact(existingArtifactId);
        EnrichedArtifact newEnrichedArtifact = (EnrichedArtifact)JSON.deepCopy((Object)existingEnrichedArtifact);
        patch.accept(newEnrichedArtifact);
        if (!Objects.equals(existingEnrichedArtifact.artifact.blueprintVersionId, newEnrichedArtifact.artifact.blueprintVersionId)) {
            if (SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(existingEnrichedArtifact.artifact.blueprintVersionId.blueprintId) && SystemProvidedConstants.isArtifactsSystemLockEnabledForBlueprint(newEnrichedArtifact.artifact.blueprintVersionId.blueprintId)) {
                EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(newEnrichedArtifact.artifact.blueprintVersionId);
                newEnrichedArtifact = EnrichedArtifact.build(enrichedBlueprintVersion.blueprint, enrichedBlueprintVersion.blueprintVersion, enrichedBlueprintVersion.blueprintVersionTrace, enrichedBlueprintVersion.blueprintRoleAssignments, newEnrichedArtifact.artifactRoleAssignments, enrichedBlueprintVersion.blueprintPermissions, newEnrichedArtifact.artifact, newEnrichedArtifact.signoffs, newEnrichedArtifact.enrichedArtifactDetails);
            } else {
                newEnrichedArtifact.artifact.blueprintVersionId = existingEnrichedArtifact.artifact.blueprintVersionId;
            }
        }
        HooksExecutionResult hooksExecutionResult = this.pythonExecutionService.applyLogicalHooksForUpdate(newEnrichedArtifact, existingEnrichedArtifact, authCtxIdentifier);
        if (Objects.equals(hooksExecutionResult.newEnrichedArtifact, existingEnrichedArtifact)) {
            return existingEnrichedArtifact;
        }
        return this.artifactsDataService.storeArtifact(hooksExecutionResult.newEnrichedArtifact, false);
    }

    @Override
    public EnrichedArtifact upsertPatchSystemArtifact(@Nullable String existingArtifactId, BlueprintVersionId blueprintVersionId, FunctionUtils.ConsumerCanThrowsException<EnrichedArtifact, IOException> patch, @Nullable String authCtxIdentifier) throws IOException {
        EnrichedArtifact storedEnrichedArtifact = StringUtils.isNotBlank((CharSequence)existingArtifactId) ? this.updateSystemArtifact(existingArtifactId, patch, authCtxIdentifier) : this.createSystemArtifact(blueprintVersionId, patch, authCtxIdentifier);
        return storedEnrichedArtifact;
    }

    private EnrichedArtifact createSystemArtifact(BlueprintVersionId blueprintVersionId, FunctionUtils.ConsumerCanThrowsException<EnrichedArtifact, IOException> patch, @Nullable String authCtxIdentifier) throws IOException {
        Artifact artifact = new Artifact();
        artifact.id = IdentifiersUtils.buildArtifactId(this.artifactIDDAO.newId());
        artifact.blueprintVersionId = blueprintVersionId;
        EnrichedBlueprintVersion enrichedBlueprintVersion = this.blueprintsDataService.getBlueprintVersion(blueprintVersionId);
        EnrichedArtifact enrichedArtifact = EnrichedArtifact.build(enrichedBlueprintVersion.blueprint, enrichedBlueprintVersion.blueprintVersion, enrichedBlueprintVersion.blueprintVersionTrace, enrichedBlueprintVersion.blueprintRoleAssignments, null, enrichedBlueprintVersion.blueprintPermissions, artifact, SignoffUtils.buildInitialSignoffsFromConfig(artifact.id, enrichedBlueprintVersion.signoffsConfigurations), EnrichedArtifactDetails.build(null, null, null));
        patch.accept(enrichedArtifact);
        enrichedArtifact.artifact.workflow = this.artifactWorkflowService.initializeWorkflow(enrichedArtifact);
        HooksExecutionResult hooksExecutionResult = this.pythonExecutionService.applyLogicalHooksForCreation(enrichedArtifact, authCtxIdentifier);
        return this.artifactsDataService.storeArtifact(hooksExecutionResult.newEnrichedArtifact, true);
    }
}

