/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.core.utils;

import java.util.Objects;

public final class Either<L, R> {
    private final L left;
    private final R right;

    private Either(L left, R right) {
        this.left = left;
        this.right = right;
    }

    public static <L, R> Either<L, R> left(L left) {
        Objects.requireNonNull(left, "The left operand cannot be null");
        return new Either<L, Object>(left, null);
    }

    public static <L, R> Either<L, R> right(R right) {
        Objects.requireNonNull(right, "The right operand cannot be null");
        return new Either<Object, R>(null, right);
    }

    public boolean isLeft() {
        return this.left != null;
    }

    public L getLeft() {
        if (!this.isLeft()) {
            throw new IllegalStateException("You cannot get a left value from an Either with a right value");
        }
        return this.left;
    }

    public boolean isRight() {
        return this.right != null;
    }

    public R getRight() {
        if (!this.isRight()) {
            throw new IllegalStateException("You cannot get a right value from an Either with a left value");
        }
        return this.right;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Either either = (Either)o;
        return Objects.equals(this.left, either.left) && Objects.equals(this.right, either.right);
    }

    public int hashCode() {
        return Objects.hash(this.left, this.right);
    }
}

