/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.gh.server.services.licensing;

import com.dataiku.dip.DKUApp;
import com.dataiku.dip.DSSMetrics;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.exceptions.DKUSecurityException;
import com.dataiku.dip.exceptions.UnauthorizedException;
import com.dataiku.dip.license.LicenseStatusService;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.server.services.UserCodes;
import com.dataiku.dip.server.services.licensing.AbstractLicenseFeaturesStatusBuilder;
import com.dataiku.dip.server.services.licensing.DkuLicenseEnforcementService;
import com.dataiku.dip.server.services.licensing.LicenseLimitsParser;
import com.dataiku.dip.server.services.licensing.LimitsStatusComputer;
import com.dataiku.dip.server.services.licensing.SublicenseEnforcer;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.gh.ApplicationConfigurator;
import com.dataiku.gh.dao.GeneralSettingsDAO;
import com.dataiku.gh.dao.UsersDAO;
import com.dataiku.gh.security.GHAuthCtx;
import com.dataiku.gh.server.services.UsersService;
import com.dataiku.gh.server.services.licensing.LicenseFeaturesStatusBuilder;
import java.util.ArrayList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class LicenseEnforcementService
implements DkuLicenseEnforcementService {
    @Autowired
    private LicenseStatusService statusService;
    @Autowired
    private UsersService usersService;
    private static final DKULogger logger = DKULogger.getLogger((String)"dku.licenseing.enforcement");

    public void checkUsersOverQuota(String explanation) throws LimitsStatusComputer.LicenseLimitException {
        LimitsStatusComputer.LicenseLimitsStatus lls = this.getLimitsStatus();
        for (LimitsStatusComputer.UsedProfileLimit upl : lls.profileLimits.values()) {
            if (upl.overQuota <= 0) continue;
            throw new LimitsStatusComputer.LicenseLimitException("Cannot " + explanation + ": you have exceeded your quota of users with profile " + upl.profile);
        }
    }

    public void checkPermissionChangeIsValid() throws LimitsStatusComputer.LicenseLimitException {
        this.checkUsersOverQuota("change permissions");
    }

    public boolean isLdapAllowed() {
        return this.getFeaturesStatus().ldapAllowed;
    }

    public void checkLdapAllowed() throws LimitsStatusComputer.LicenseLimitException {
        if (!this.isLdapAllowed()) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to enable LDAP authentication");
        }
    }

    public LimitsStatusComputer.LicensedProfile getUserProfileByNameOrNull(String profile) {
        boolean addNoneProfile;
        LimitsStatusComputer.LicenseLimitsStatus lls = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
            LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        return (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(profile);
    }

    public LimitsStatusComputer.LicensedProfile getUserProfileByNameOrFallback(String profile) {
        LimitsStatusComputer.LicensedProfile lp;
        boolean addNoneProfile;
        LimitsStatusComputer.LicenseLimitsStatus lls = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
            LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if ((lp = (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(profile)) == null) {
            return (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(lls.fallbackProfile);
        }
        return lp;
    }

    public LimitsStatusComputer.LicensedProfile getUserProfileByNameMand(String profile) throws DKUSecurityException {
        LimitsStatusComputer.LicensedProfile lp;
        boolean addNoneProfile;
        LimitsStatusComputer.LicenseLimitsStatus lls = new LimitsStatusComputer.LicenseLimitsStatus();
        LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
        if (ls.hasLicense && ls.licenseContent.properties != null) {
            LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
            LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)lls);
        }
        if ((lp = (LimitsStatusComputer.LicensedProfile)lls.licensedProfiles.get(profile)) == null) {
            throw new DKUSecurityException("Unrecognized user profile");
        }
        return lp;
    }

    public static DKUSecurityException forbiddenByUserProfile(AuthCtx authCtx, String action) {
        return LicenseEnforcementService.forbiddenByUserProfile(authCtx, action, false);
    }

    public static DKUSecurityException forbiddenByUserProfile(AuthCtx authCtx, String action, boolean mustBeAdmin) {
        UserCodes userCode = mustBeAdmin ? UserCodes.ERR_USER_ACTION_FORBIDDEN_MUST_BE_ADMIN : UserCodes.ERR_USER_ACTION_FORBIDDEN_BY_PROFILE;
        return new UnauthorizedException("Your user profile (" + authCtx.getUserProfile() + ") does not allow you to " + action + ".", "user-profile-action-denied").withCode((InfoMessage.MessageCode)userCode);
    }

    public void checkAdminAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((GHAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayAdmin) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "administrate DSS", true);
        }
    }

    public LimitsStatusComputer.LicenseLimitsStatus getLimitsStatus() {
        GeneralSettingsDAO.GeneralSettings gs = ApplicationConfigurator.getGeneralSettingsUnsafeAutoTXN();
        try (DSSMetrics.TimeCtx c = DSSMetrics.timeCtx((String)"dku.services.licensing.getLimitsStatus");){
            boolean addNoneProfile;
            LimitsStatusComputer.LicenseLimitsStatus ret = new LimitsStatusComputer.LicenseLimitsStatus();
            LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
            if (ls.hasLicense && ls.licenseContent.properties != null) {
                LicenseLimitsParser.parseLicensedProfiles((LicenseStatusService.LicensingStatus)ls, (LimitsStatusComputer.LicenseLimitsStatus)ret);
            }
            if (addNoneProfile = DKUApp.getParams().getBoolParam("dku.licensing.addNoneProfile", true)) {
                LicenseLimitsParser.addNoneProfile((LimitsStatusComputer.LicenseLimitsStatus)ret);
            }
            logger.trace(() -> "After parsing of profiles: " + JSON.log((Object)ret));
            new SublicenseEnforcer(ls.sublicense).restrict(ret);
            logger.trace(() -> "After sublicense: " + JSON.log((Object)ret));
            try {
                ArrayList<String> userProfiles = new ArrayList<String>();
                ArrayList trialProfiles = new ArrayList();
                for (UsersDAO.User u : this.usersService.listUsersInternalUnsafeEnabledOnly()) {
                    userProfiles.add(u.userProfile);
                }
                ret.profileLimits = new LimitsStatusComputer().getLimitsStatus(ret.licensedProfiles.values(), ret.fallbackProfile, userProfiles, trialProfiles);
            }
            catch (Exception e) {
                logger.error((Object)"Failed to get licensing limits", (Throwable)e);
            }
            logger.trace(() -> "License enforcement status " + JSON.prettyLog((Object)ret));
            LimitsStatusComputer.LicenseLimitsStatus licenseLimitsStatus = ret;
            return licenseLimitsStatus;
        }
    }

    public AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus getFeaturesStatus() {
        try (DSSMetrics.TimeCtx c = DSSMetrics.timeCtx((String)"dku.services.licensing.getFeaturesStatus");){
            LicenseStatusService.LicensingStatus ls = this.statusService.getLicensingStatus();
            AbstractLicenseFeaturesStatusBuilder.LicenseFeaturesStatus licenseFeaturesStatus = LicenseFeaturesStatusBuilder.getFeaturesStatus(ls);
            return licenseFeaturesStatus;
        }
    }

    public boolean isGovernAllowed() {
        return this.getFeaturesStatus().governAllowed;
    }

    public void checkGovernAllowed() throws LimitsStatusComputer.LicenseLimitException {
        if (!this.isGovernAllowed()) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to use Govern");
        }
    }

    public boolean isGovernBlueprintDesignerAllowed() {
        return this.getFeaturesStatus().governBlueprintDesignerAllowed;
    }

    public void checkGovernActionDesignerAllowed() throws LimitsStatusComputer.LicenseLimitException {
        if (!this.isGovernBlueprintDesignerAllowed()) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to use the Action Designer");
        }
    }

    public void checkGovernBlueprintDesignerAllowed() throws LimitsStatusComputer.LicenseLimitException {
        if (!this.isGovernBlueprintDesignerAllowed()) {
            throw new LimitsStatusComputer.LicenseLimitException("Your license does not allow you to use the Govern Blueprint Designer");
        }
    }

    public void checkReadGovernAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((GHAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayReadGovern) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "use Govern");
        }
    }

    public void checkWriteGovernAllowed(AuthCtx authCtx) throws DKUSecurityException {
        if (!((GHAuthCtx)authCtx).isConfigurableAPIKey() && !this.getUserProfileByNameOrFallback((String)authCtx.getUserProfile()).mayWriteGovern) {
            throw LicenseEnforcementService.forbiddenByUserProfile(authCtx, "edit Govern items");
        }
    }
}

