/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.snowflake;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.iceberg.exceptions.NoSuchNamespaceException;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.jdbc.JdbcClientPool;
import org.apache.iceberg.jdbc.UncheckedInterruptedException;
import org.apache.iceberg.jdbc.UncheckedSQLException;
import org.apache.iceberg.relocated.com.google.common.annotations.VisibleForTesting;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.snowflake.SnowflakeClient;
import org.apache.iceberg.snowflake.SnowflakeIdentifier;
import org.apache.iceberg.snowflake.SnowflakeTableMetadata;

class JdbcSnowflakeClient
implements SnowflakeClient {
    static final String EXPECTED_JDBC_IMPL = "net.snowflake.client.jdbc.SnowflakeDriver";
    @VisibleForTesting
    static final Set<Integer> DATABASE_NOT_FOUND_ERROR_CODES = ImmutableSet.of((Object)2001, (Object)2003, (Object)2043);
    @VisibleForTesting
    static final Set<Integer> SCHEMA_NOT_FOUND_ERROR_CODES = ImmutableSet.of((Object)2001, (Object)2003, (Object)2043);
    @VisibleForTesting
    static final Set<Integer> TABLE_NOT_FOUND_ERROR_CODES = ImmutableSet.of((Object)2001, (Object)2003, (Object)2043);
    public static final ResultSetParser<List<SnowflakeIdentifier>> DATABASE_RESULT_SET_HANDLER = rs -> {
        ArrayList databases = Lists.newArrayList();
        while (rs.next()) {
            String databaseName = rs.getString("name");
            databases.add(SnowflakeIdentifier.ofDatabase(databaseName));
        }
        return databases;
    };
    public static final ResultSetParser<List<SnowflakeIdentifier>> SCHEMA_RESULT_SET_HANDLER = rs -> {
        ArrayList schemas = Lists.newArrayList();
        while (rs.next()) {
            String databaseName = rs.getString("database_name");
            String schemaName = rs.getString("name");
            schemas.add(SnowflakeIdentifier.ofSchema(databaseName, schemaName));
        }
        return schemas;
    };
    public static final ResultSetParser<List<SnowflakeIdentifier>> TABLE_RESULT_SET_HANDLER = rs -> {
        ArrayList tables = Lists.newArrayList();
        while (rs.next()) {
            String databaseName = rs.getString("database_name");
            String schemaName = rs.getString("schema_name");
            String tableName = rs.getString("name");
            tables.add(SnowflakeIdentifier.ofTable(databaseName, schemaName, tableName));
        }
        return tables;
    };
    public static final ResultSetParser<SnowflakeTableMetadata> TABLE_METADATA_RESULT_SET_HANDLER = rs -> {
        if (!rs.next()) {
            return null;
        }
        String rawJsonVal = rs.getString("METADATA");
        return SnowflakeTableMetadata.parseJson(rawJsonVal);
    };
    private final JdbcClientPool connectionPool;
    private QueryHarness queryHarness;

    JdbcSnowflakeClient(JdbcClientPool conn) {
        Preconditions.checkArgument((null != conn ? 1 : 0) != 0, (Object)"JdbcClientPool must be non-null");
        this.connectionPool = conn;
        this.queryHarness = new QueryHarness();
    }

    @VisibleForTesting
    void setQueryHarness(QueryHarness queryHarness) {
        this.queryHarness = queryHarness;
    }

    @Override
    public boolean databaseExists(SnowflakeIdentifier database) {
        List schemas;
        Preconditions.checkArgument((database.type() == SnowflakeIdentifier.Type.DATABASE ? 1 : 0) != 0, (String)"databaseExists requires a DATABASE identifier, got '%s'", (Object)database);
        String finalQuery = "SHOW SCHEMAS IN DATABASE IDENTIFIER(?) LIMIT 1";
        try {
            schemas = (List)this.connectionPool.run(conn -> this.queryHarness.query((Connection)conn, "SHOW SCHEMAS IN DATABASE IDENTIFIER(?) LIMIT 1", SCHEMA_RESULT_SET_HANDLER, database.databaseName()));
        }
        catch (SQLException e) {
            if (DATABASE_NOT_FOUND_ERROR_CODES.contains(e.getErrorCode())) {
                return false;
            }
            throw new UncheckedSQLException((Throwable)e, "Failed to check if database '%s' exists", new Object[]{database});
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted while checking if database '%s' exists", new Object[]{database});
        }
        return !schemas.isEmpty();
    }

    @Override
    public boolean schemaExists(SnowflakeIdentifier schema) {
        Preconditions.checkArgument((schema.type() == SnowflakeIdentifier.Type.SCHEMA ? 1 : 0) != 0, (String)"schemaExists requires a SCHEMA identifier, got '%s'", (Object)schema);
        if (!this.databaseExists(SnowflakeIdentifier.ofDatabase(schema.databaseName()))) {
            return false;
        }
        String finalQuery = "SHOW TABLES IN SCHEMA IDENTIFIER(?) LIMIT 1";
        try {
            this.connectionPool.run(conn -> this.queryHarness.query((Connection)conn, "SHOW TABLES IN SCHEMA IDENTIFIER(?) LIMIT 1", TABLE_RESULT_SET_HANDLER, schema.toIdentifierString()));
        }
        catch (SQLException e) {
            if (SCHEMA_NOT_FOUND_ERROR_CODES.contains(e.getErrorCode())) {
                return false;
            }
            throw new UncheckedSQLException((Throwable)e, "Failed to check if schema '%s' exists", new Object[]{schema});
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted while checking if schema '%s' exists", new Object[]{schema});
        }
        return true;
    }

    @Override
    public List<SnowflakeIdentifier> listDatabases() {
        List databases;
        try {
            databases = (List)this.connectionPool.run(conn -> this.queryHarness.query((Connection)conn, "SHOW DATABASES IN ACCOUNT", DATABASE_RESULT_SET_HANDLER, new String[0]));
        }
        catch (SQLException e) {
            throw this.snowflakeExceptionToIcebergException(SnowflakeIdentifier.ofRoot(), e, "Failed to list databases");
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted while listing databases", new Object[0]);
        }
        databases.forEach(db -> Preconditions.checkState((db.type() == SnowflakeIdentifier.Type.DATABASE ? 1 : 0) != 0, (String)"Expected DATABASE, got identifier '%s'", (Object)db));
        return databases;
    }

    @Override
    public List<SnowflakeIdentifier> listSchemas(SnowflakeIdentifier scope) {
        List schemas;
        StringBuilder baseQuery = new StringBuilder("SHOW SCHEMAS");
        String[] queryParams = null;
        switch (scope.type()) {
            case ROOT: {
                baseQuery.append(" IN ACCOUNT");
                break;
            }
            case DATABASE: {
                baseQuery.append(" IN DATABASE IDENTIFIER(?)");
                queryParams = new String[]{scope.toIdentifierString()};
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported scope type for listSchemas: %s", scope));
            }
        }
        String finalQuery = baseQuery.toString();
        String[] finalQueryParams = queryParams;
        try {
            schemas = (List)this.connectionPool.run(conn -> this.queryHarness.query((Connection)conn, finalQuery, SCHEMA_RESULT_SET_HANDLER, finalQueryParams));
        }
        catch (SQLException e) {
            throw this.snowflakeExceptionToIcebergException(scope, e, String.format("Failed to list schemas for scope '%s'", scope));
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted while listing schemas for scope '%s'", new Object[]{scope});
        }
        schemas.forEach(schema -> Preconditions.checkState((schema.type() == SnowflakeIdentifier.Type.SCHEMA ? 1 : 0) != 0, (String)"Expected SCHEMA, got identifier '%s' for scope '%s'", (Object)schema, (Object)scope));
        return schemas;
    }

    @Override
    public List<SnowflakeIdentifier> listIcebergTables(SnowflakeIdentifier scope) {
        List tables;
        StringBuilder baseQuery = new StringBuilder("SHOW ICEBERG TABLES");
        String[] queryParams = null;
        switch (scope.type()) {
            case ROOT: {
                baseQuery.append(" IN ACCOUNT");
                break;
            }
            case DATABASE: {
                baseQuery.append(" IN DATABASE IDENTIFIER(?)");
                queryParams = new String[]{scope.toIdentifierString()};
                break;
            }
            case SCHEMA: {
                baseQuery.append(" IN SCHEMA IDENTIFIER(?)");
                queryParams = new String[]{scope.toIdentifierString()};
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Unsupported scope type for listIcebergTables: %s", scope));
            }
        }
        String finalQuery = baseQuery.toString();
        String[] finalQueryParams = queryParams;
        try {
            tables = (List)this.connectionPool.run(conn -> this.queryHarness.query((Connection)conn, finalQuery, TABLE_RESULT_SET_HANDLER, finalQueryParams));
        }
        catch (SQLException e) {
            throw this.snowflakeExceptionToIcebergException(scope, e, String.format("Failed to list tables for scope '%s'", scope));
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted while listing tables for scope '%s'", new Object[]{scope});
        }
        tables.forEach(table -> Preconditions.checkState((table.type() == SnowflakeIdentifier.Type.TABLE ? 1 : 0) != 0, (String)"Expected TABLE, got identifier '%s' for scope '%s'", (Object)table, (Object)scope));
        return tables;
    }

    @Override
    public SnowflakeTableMetadata loadTableMetadata(SnowflakeIdentifier tableIdentifier) {
        SnowflakeTableMetadata tableMeta;
        Preconditions.checkArgument((tableIdentifier.type() == SnowflakeIdentifier.Type.TABLE ? 1 : 0) != 0, (String)"loadTableMetadata requires a TABLE identifier, got '%s'", (Object)tableIdentifier);
        try {
            String finalQuery = "SELECT SYSTEM$GET_ICEBERG_TABLE_INFORMATION(?) AS METADATA";
            tableMeta = (SnowflakeTableMetadata)this.connectionPool.run(conn -> this.queryHarness.query((Connection)conn, "SELECT SYSTEM$GET_ICEBERG_TABLE_INFORMATION(?) AS METADATA", TABLE_METADATA_RESULT_SET_HANDLER, tableIdentifier.toIdentifierString()));
        }
        catch (SQLException e) {
            throw this.snowflakeExceptionToIcebergException(tableIdentifier, e, String.format("Failed to get table metadata for '%s'", tableIdentifier));
        }
        catch (InterruptedException e) {
            throw new UncheckedInterruptedException((Throwable)e, "Interrupted while getting table metadata for '%s'", new Object[]{tableIdentifier});
        }
        return tableMeta;
    }

    @Override
    public void close() {
        this.connectionPool.close();
    }

    private RuntimeException snowflakeExceptionToIcebergException(SnowflakeIdentifier identifier, SQLException ex, String defaultExceptionMessage) {
        if (identifier.type() == SnowflakeIdentifier.Type.DATABASE && DATABASE_NOT_FOUND_ERROR_CODES.contains(ex.getErrorCode()) || identifier.type() == SnowflakeIdentifier.Type.SCHEMA && SCHEMA_NOT_FOUND_ERROR_CODES.contains(ex.getErrorCode())) {
            return new NoSuchNamespaceException((Throwable)ex, "Identifier not found: '%s'. Underlying exception: '%s'", new Object[]{identifier, ex.getMessage()});
        }
        if (identifier.type() == SnowflakeIdentifier.Type.TABLE && TABLE_NOT_FOUND_ERROR_CODES.contains(ex.getErrorCode())) {
            return new NoSuchTableException((Throwable)ex, "Identifier not found: '%s'. Underlying exception: '%s'", new Object[]{identifier, ex.getMessage()});
        }
        return new UncheckedSQLException((Throwable)ex, "Exception Message: %s", new Object[]{defaultExceptionMessage});
    }

    static class QueryHarness {
        QueryHarness() {
        }

        public <T> T query(Connection conn, String sql, ResultSetParser<T> parser, String ... args) throws SQLException {
            try (PreparedStatement statement = conn.prepareStatement(sql);){
                T t;
                block14: {
                    if (args != null) {
                        for (int i = 0; i < args.length; ++i) {
                            statement.setString(i + 1, args[i]);
                        }
                    }
                    ResultSet rs = statement.executeQuery();
                    try {
                        t = parser.parse(rs);
                        if (rs == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            try {
                                rs.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    rs.close();
                }
                return t;
            }
        }
    }

    @FunctionalInterface
    static interface ResultSetParser<T> {
        public T parse(ResultSet var1) throws SQLException;
    }
}

