/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.lambda.dataload;

import com.dataiku.dip.connections.AbstractSQLConnection;
import com.dataiku.dip.connections.ConnectionWithEncryptedFields;
import com.dataiku.dip.connections.ConnectionsDAO;
import com.dataiku.dip.connections.DSSConnection;
import com.dataiku.dip.connections.OracleConnection;
import com.dataiku.dip.connections.SQLConnectionProvider;
import com.dataiku.dip.coremodel.Dataset;
import com.dataiku.dip.coremodel.FormatParams;
import com.dataiku.dip.coremodel.InfoMessage;
import com.dataiku.dip.coremodel.SerializedDataset;
import com.dataiku.dip.dataflow.exec.stream.ToDatasetStreamer;
import com.dataiku.dip.datalayer.ColumnFactory;
import com.dataiku.dip.datalayer.ProcessorOutput;
import com.dataiku.dip.datalayer.RowFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamColumnFactory;
import com.dataiku.dip.datalayer.streamimpl.StreamRowFactory;
import com.dataiku.dip.datasets.DatasetHandler;
import com.dataiku.dip.datasets.StreamableDatasetSelection;
import com.dataiku.dip.datasets.UniversalSingleThreadPusher;
import com.dataiku.dip.datasets.fs.FilesystemDatasetConfig;
import com.dataiku.dip.datasets.sql.AbstractSQLDatasetHandler;
import com.dataiku.dip.exceptions.CodedException;
import com.dataiku.dip.input.DatasetHandlerFactory;
import com.dataiku.dip.input.formats.csv.CSVFormatConfig;
import com.dataiku.dip.output.Output;
import com.dataiku.dip.partitioning.Partition;
import com.dataiku.dip.security.AuthCtx;
import com.dataiku.dip.security.DSSAuthCtx;
import com.dataiku.dip.security.PasswordEncryptionService;
import com.dataiku.dip.sql.OracleSQLDialect;
import com.dataiku.dip.sql.SQLDialect;
import com.dataiku.dip.util.CachedJSONFile;
import com.dataiku.dip.utils.DKULogger;
import com.dataiku.dip.utils.JSON;
import com.dataiku.dip.warnings.WarningsContext;
import com.dataiku.lambda.LambdaContext;
import com.dataiku.lambda.dataload.LoadedDataMapping;
import com.dataiku.lambda.misc.LambdaCodes;
import com.dataiku.lambda.model.serverconfig.DatasetResource;
import com.dataiku.lambda.model.serverconfig.LambdaEndpointConfig;
import com.dataiku.lambda.model.serverconfig.LambdaServiceConfig;
import com.dataiku.lambda.model.serverconfig.PredictionEndpointConfigBase;
import com.dataiku.lambda.model.serverconfig.PredictionFeaturesLeftJoinMapping;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.MultimapBuilder;
import java.io.File;
import java.io.IOException;
import java.sql.Statement;
import java.util.Map;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;

public class DataLoadManager {
    public static final String BUNDLED_CONNECTION = "___dku_bundled";
    @Autowired
    private LambdaContext lambdaContext;
    @Autowired
    private ConnectionsDAO connectionsDAO;
    @Autowired
    private PasswordEncryptionService cryptoService;
    private CachedJSONFile<LoadedDataMapping> cache;
    private static DKULogger logger = DKULogger.getLogger((String)"dku.lambda.dataloadmanager");

    @PostConstruct
    public void init() {
        this.cache = new CachedJSONFile(this.lambdaContext.getFile(new String[]{"loaded-data-mapping.json"}), LoadedDataMapping.class);
    }

    public synchronized void loadServiceGeneration(String serviceId, String generationId, File serviceGenDir, LambdaServiceConfig config) throws Exception {
        DSSConnection conn;
        ListMultimap indices = MultimapBuilder.linkedHashKeys().linkedListValues().build();
        logger.infoV("Loading data resources for %s-%s", new Object[]{serviceId, generationId});
        LoadedDataMapping mapping = this.readMapping();
        logger.infoV("Existing mapping: %s", new Object[]{JSON.log((Object)mapping)});
        try {
            conn = this.connectionsDAO.getConnection((AuthCtx)DSSAuthCtx.newNone(), BUNDLED_CONNECTION);
            if (conn instanceof ConnectionWithEncryptedFields) {
                ((ConnectionWithEncryptedFields)conn).decryptFields(this.cryptoService);
            }
        }
        catch (NullPointerException npe) {
            conn = null;
        }
        for (DatasetResource dr : config.datasetResources) {
            switch (dr.packagingType) {
                case REFERENCED: {
                    break;
                }
                case BUNDLED_INTERNAL: {
                    throw new Error("Not implemented yet");
                }
                case BUNDLED_TOCONNECTION: {
                    LoadedDataMapping.DataGen dg = mapping.getMapped(serviceId, dr.resourceId, generationId);
                    if (dg != null) {
                        logger.infoV("Resource %s - %s already loaded for generation %s", new Object[]{serviceId, dr.resourceId, generationId});
                        break;
                    }
                    if (conn == null) {
                        throw new CodedException((InfoMessage.MessageCode)LambdaCodes.ERR_LAMBDA_NO_BUNDLED_CONNECTION, "No connection for bundled data in the dev server, please contact your administrator");
                    }
                    if (conn.isProperSQL()) {
                        File dataDir = new File(serviceGenDir, "datasets/" + dr.resourceId);
                        Object destTable = serviceId + "_" + dr.resourceId.replace('.', '_') + "_" + generationId;
                        if (conn instanceof OracleConnection) {
                            destTable = ((OracleConnection)conn).getDialect().makeCompliantIdentifier((String)destTable, 5, "_");
                        }
                        this.loadToSQL((AuthCtx)DSSAuthCtx.newNone(), dr, dataDir, conn, (String)destTable);
                        for (LambdaEndpointConfig epc : config.endpoints) {
                            if (!(epc instanceof PredictionEndpointConfigBase)) continue;
                            for (PredictionFeaturesLeftJoinMapping ljm : ((PredictionEndpointConfigBase)epc).enrichMapping) {
                                if (!dr.resourceId.equals(ljm.lookupResource)) continue;
                                for (PredictionFeaturesLeftJoinMapping.KeyEltMatching kem : ljm.on) {
                                    indices.put(destTable, (Object)kem.resourceLookupCol);
                                }
                            }
                        }
                        mapping.setMapping(serviceId, dr.resourceId, generationId, (String)destTable);
                        break;
                    }
                    throw new Error("Non-SQL bundled connection is not handled");
                }
            }
        }
        logger.infoV("Updating mapping: %s", new Object[]{JSON.log((Object)mapping)});
        this.saveMapping(mapping);
        if (!indices.isEmpty()) {
            assert (conn instanceof AbstractSQLConnection);
            logger.infoV("Adding indices for resources of %s-%s", new Object[]{serviceId, generationId});
            AbstractSQLConnection sqlc = (AbstractSQLConnection)conn;
            SQLConnectionProvider.SQLConnectionData connData = sqlc.getConnectionData_NT((AuthCtx)DSSAuthCtx.newNone(), null);
            switch (connData.getType()) {
                case VERTICA: 
                case TERADATA: 
                case GREENPLUM: {
                    return;
                }
            }
            SQLDialect dialect = connData.getDialect();
            try (SQLConnectionProvider.SQLConnectionWrapper jdbcConn = SQLConnectionProvider.newConnection((SQLConnectionProvider.SQLConnectionData)connData, (AuthCtx)DSSAuthCtx.newNone(), null);){
                try (Statement st = jdbcConn.createStatement();){
                    int i = 0;
                    for (Map.Entry index : indices.entries()) {
                        try {
                            Object indexName = "idx_" + (String)index.getKey();
                            indexName = dialect instanceof OracleSQLDialect ? ((OracleSQLDialect)dialect).makeCompliantIdentifier((String)indexName, "_" + i++) : (String)indexName + "_" + i++;
                            AbstractSQLConnection.SQLManagedDatasetNamingRule namingRule = connData.getConnection().getParams().namingRule;
                            st.execute("CREATE INDEX " + dialect.quoteIdentifier((String)indexName) + " ON " + dialect.getQuotedTableFullName(namingRule.catalog, namingRule.schemaName, (String)index.getKey()) + " (" + dialect.quoteIdentifier((String)index.getValue()) + ");");
                        }
                        catch (Exception e) {
                            logger.warn((Object)("Could not create index for lookup column " + (String)index.getValue() + " on " + (String)index.getKey()), (Throwable)e);
                        }
                    }
                }
                jdbcConn.commit();
            }
        }
    }

    public synchronized void unloadServiceGeneration(String serviceId, String generationId) throws Exception {
        LoadedDataMapping mapping = this.readMapping();
        for (LoadedDataMapping.DataGen dg : mapping.getAllForServiceGen(serviceId, generationId)) {
            logger.infoV("Unloading data: %s", new Object[]{JSON.log((Object)dg)});
            assert (dg.genId.equals(generationId));
            assert (dg.serviceId.equals(serviceId));
            DSSConnection conn = this.connectionsDAO.getMandatoryConnection((AuthCtx)DSSAuthCtx.newNone(), BUNDLED_CONNECTION);
            if (conn.isProperSQL()) {
                this.unloadSQL((AbstractSQLConnection)conn, dg.tableLike);
                mapping.unmap(serviceId, dg.resourceId, generationId);
                continue;
            }
            throw new Error("Bundling to non-SQL is not handled");
        }
        this.saveMapping(mapping);
    }

    public synchronized LoadedDataMapping.DataGen getMapped(String serviceId, String resourceId, String generationId) throws IOException {
        LoadedDataMapping mapping = this.readMapping();
        return mapping.getMapped(serviceId, resourceId, generationId);
    }

    private void saveMapping(LoadedDataMapping mapping) throws IOException {
        this.cache.write((Object)mapping);
    }

    private LoadedDataMapping readMapping() throws IOException {
        return (LoadedDataMapping)this.cache.get();
    }

    private void unloadSQL(AbstractSQLConnection conn, String destTable) throws Exception {
        SQLConnectionProvider.SQLConnectionData connData = conn.getConnectionData_NT((AuthCtx)DSSAuthCtx.newNone(), null);
        if (connData.getConnection() instanceof ConnectionWithEncryptedFields) {
            ((ConnectionWithEncryptedFields)connData.getConnection()).decryptFields(this.cryptoService);
        }
        try (SQLConnectionProvider.SQLConnectionWrapper jdbcConn = SQLConnectionProvider.newConnection((SQLConnectionProvider.SQLConnectionData)connData, (AuthCtx)DSSAuthCtx.newNone(), null);){
            try (Statement st = jdbcConn.createStatement();){
                AbstractSQLConnection.SQLManagedDatasetNamingRule namingRule = connData.getConnection().getParams().namingRule;
                st.execute("DROP TABLE " + connData.getDialect().getQuotedTableFullName(namingRule.catalog, namingRule.schemaName, destTable));
            }
            jdbcConn.commit();
        }
    }

    private void loadToSQL(AuthCtx authCtx, DatasetResource resource, File resourceDataDir, DSSConnection conn, String destTable) throws Exception {
        logger.infoV("Starting to load resource %s to connection %s, table %s", new Object[]{resource.resourceId, conn.name, destTable});
        Dataset targetDataset = Dataset.fromSerialized((String)"XXX.target", (SerializedDataset)resource.dssDataset);
        DatasetHandlerFactory.getMeta((String)conn.getType()).fillManagedDatasetParams(targetDataset, conn, null);
        ((AbstractSQLDatasetHandler.AbstractSQLConfig)targetDataset.getParamsAs(AbstractSQLDatasetHandler.AbstractSQLConfig.class)).table = destTable;
        targetDataset.fixupSchemaPerDatasetConstraint(targetDataset.getSchema(), conn);
        resource.dssDataset.setParams(targetDataset.getParams());
        StreamColumnFactory scf = new StreamColumnFactory();
        StreamRowFactory srf = new StreamRowFactory();
        ToDatasetStreamer streamer = ToDatasetStreamer.newWithAutoBucketing((AuthCtx)authCtx, (Dataset)targetDataset, (Partition)new Partition(null), (ColumnFactory)scf, (WarningsContext)new WarningsContext(), (Output.WriteMode)Output.WriteMode.OVERWRITE);
        ProcessorOutput out = streamer.getAsOutput();
        Dataset inputDataset = new Dataset().withType("Filesystem").withFullName("XXX.source");
        FilesystemDatasetConfig fdc = new FilesystemDatasetConfig();
        fdc.path = resourceDataDir.getAbsolutePath();
        inputDataset.setParams((DatasetHandler.DatasetParams)fdc);
        inputDataset.setSchema(targetDataset.getSchema());
        inputDataset.setFormatType(resource.bundledFormatType);
        inputDataset.setFormatParams((FormatParams)CSVFormatConfig.getStandardTabExcelFormat());
        UniversalSingleThreadPusher.push((AuthCtx)authCtx, (Dataset)inputDataset, (StreamableDatasetSelection)null, (ProcessorOutput)out, (ColumnFactory)scf, (RowFactory)srf);
        logger.info((Object)"done, closing");
        out.lastRowEmitted();
    }
}

