from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..acf.acf import ACF, _ACF
    from ..durbin_watson.durbin_watson import DurbinWatson, _DurbinWatson
    from ..mann_kendall_test.mann_kendall_test import MannKendallTest, _MannKendallTest
    from ..pacf.pacf import PACF, _PACF
    from ..stl_decomposition.stl_decomposition import STLDecomposition, _STLDecomposition
    from ..unit_root_test_adf.unit_root_test_adf import UnitRootTestADF, _UnitRootTestADF
    from ..unit_root_test_kpss.unit_root_test_kpss import UnitRootTestKPSS, _UnitRootTestKPSS
    from ..unit_root_test_za.unit_root_test_za import UnitRootTestZA, _UnitRootTestZA
from ...computation.computation import Computation, _Computation

'''
Translated from class com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation
Via: PyModel annotation in the class hierarchy
'''


class _TimeSeriesComputation(_Computation, TypedDict):
    seriesColumn: str
    timeColumn: str


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation
TimeSeriesComputation = Union[
    'ACF',
    'DurbinWatson',
    'MannKendallTest',
    'PACF',
    'STLDecomposition',
    'UnitRootTestADF',
    'UnitRootTestKPSS',
    'UnitRootTestZA',
]

# Types of class com.dataiku.dip.eda.compute.computations.timeseries.TimeSeriesComputation in PolyJSON mappings (as literal type)
TimeSeriesComputationTypeLiteral = Literal["acf", "durbin_watson", "mann_kendall", "pacf", "stl_decomposition", "unit_root_adf", "unit_root_kpss", "unit_root_za", ]


# EOF
