from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .generated_key import GeneratedKey, _GeneratedKey
    from .generated_output_storage_location import GeneratedOutputStorageLocation
from .blocks_graph_block import BlocksGraphBlock, _BlocksGraphBlock

'''
Translated from class com.dataiku.dip.dao.SavedModel$ForEachBlock
Via: com.dataiku.dip.dao.SavedModel$BlocksGraphBlock
'''


class _ForEachBlock(_BlocksGraphBlock, TypedDict):
    type: Literal["FOR_EACH"]
    blockIdToRepeat: str
    forEachInputKey: str
    generatedOutputStorageLocation: 'GeneratedOutputStorageLocation'
    generatedScratchpadKeys: List['GeneratedKey']
    generatedStateKeys: List['GeneratedKey']
    nextBlock: str
    sourceExpression: str
    targetOutputKey: str


ForEachBlock = _ForEachBlock


# EOF
