from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .and_routing_condition_clause import AndRoutingConditionClause, _AndRoutingConditionClause
    from .expression_routing_condition_clause import ExpressionRoutingConditionClause, _ExpressionRoutingConditionClause
    from .llm_based_decision_routing_condition_clause import LLMBasedDecisionRoutingConditionClause, _LLMBasedDecisionRoutingConditionClause
    from .or_routing_condition_clause import OrRoutingConditionClause, _OrRoutingConditionClause
    from .scratchpad_has_keys_routing_condition_clause import ScratchpadHasKeysRoutingConditionClause, _ScratchpadHasKeysRoutingConditionClause
    from .state_has_keys_routing_condition_clause import StateHasKeysRoutingConditionClause, _StateHasKeysRoutingConditionClause
    from .tools_called_in_history_routing_condition_clause import ToolsCalledInHistoryRoutingConditionClause, _ToolsCalledInHistoryRoutingConditionClause

'''
Translated from class com.dataiku.dip.dao.SavedModel$RoutingConditionClause
Via: PyModel annotation in the class hierarchy
'''


class _RoutingConditionClause(TypedDict):
    pass


# List of all concrete subclasses of com.dataiku.dip.dao.SavedModel$RoutingConditionClause
RoutingConditionClause = Union[
    'AndRoutingConditionClause',
    'ExpressionRoutingConditionClause',
    'LLMBasedDecisionRoutingConditionClause',
    'OrRoutingConditionClause',
    'ScratchpadHasKeysRoutingConditionClause',
    'StateHasKeysRoutingConditionClause',
    'ToolsCalledInHistoryRoutingConditionClause',
]

# Types of class com.dataiku.dip.dao.SavedModel$RoutingConditionClause in PolyJSON mappings (as literal type)
RoutingConditionClauseTypeLiteral = Literal["AND", "EXPRESSION", "LLM_BASED", "OR", "SCRATCHPAD_HAS_KEYS", "STATE_HAS_KEYS", "TOOLS_CALLED", ]


# EOF
