from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..multivariate.fetch_csv.fetch_csv import FetchCSV, _FetchCSV
    from ..multivariate.fetch_values.fetch_values import FetchValues, _FetchValues
    from ..multivariate.pca.pca import PCA, _PCA
from .computation import Computation, _Computation

'''
Translated from class com.dataiku.dip.eda.compute.computations.Computation$MultivariateComputation
Via: PyModel annotation in the class hierarchy
'''


class _MultivariateComputation(_Computation, TypedDict):
    columns: List[str]


# List of all concrete subclasses of com.dataiku.dip.eda.compute.computations.Computation$MultivariateComputation
MultivariateComputation = Union[
    'FetchCSV',
    'FetchValues',
    'PCA',
]

# Types of class com.dataiku.dip.eda.compute.computations.Computation$MultivariateComputation in PolyJSON mappings (as literal type)
MultivariateComputationTypeLiteral = Literal["fetch_csv", "fetch_values", "pca", ]


# EOF
