from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .boundary_date_mode import BoundaryDateMode
    from .day_of_week import DayOfWeek
    from .duplicate_timestamps_handling_method import DuplicateTimestampsHandlingMethod
    from .end_of_half_year import EndOfHalfYear
    from .end_of_quarter import EndOfQuarter
    from .end_of_year import EndOfYear
    from .extrapolation_method import ExtrapolationMethod
    from .interpolation_method import InterpolationMethod
    from .time_unit import TimeUnit
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.resampling.ResamplerSettings
Via: com.dataiku.dip.eda.compute.resampling.ResamplerSpec
'''


class _ResamplerSettings(_ImmutableValueObject, TypedDict):
    customEndDate: str
    customStartDate: str
    duplicateTimestampsHandlingMethod: 'DuplicateTimestampsHandlingMethod'
    endDateMode: 'BoundaryDateMode'
    extrapolationConstantValue: float
    extrapolationMethod: 'ExtrapolationMethod'
    interpolationConstantValue: float
    interpolationMethod: 'InterpolationMethod'
    nUnits: int
    startDateMode: 'BoundaryDateMode'
    timeUnit: 'TimeUnit'
    timeUnitEndOfHalfYear: 'EndOfHalfYear'
    timeUnitEndOfQuarter: 'EndOfQuarter'
    timeUnitEndOfWeek: 'DayOfWeek'
    timeUnitEndOfYear: 'EndOfYear'
    timeUnitMonthlyAlignment: int


ResamplerSettings = _ResamplerSettings


# EOF
