from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .llm_mesh_trace_span import LLMMeshTraceSpan, _LLMMeshTraceSpan
    from .simple_embedding_response_or_error import SimpleEmbeddingResponseOrError, _SimpleEmbeddingResponseOrError
    from .total_usage import TotalUsage, _TotalUsage

'''
Translated from class com.dataiku.dip.llm.online.LLMClient$SimpleEmbeddingResponse
Via: PyModel annotation in the class hierarchy
'''


class _SimpleEmbeddingResponse(TypedDict):
    additionalInformation: Dict[str, Any]
    embedding: List[float]
    estimatedCost: float
    fromCache: bool
    promptTokens: int
    tokenCountsAreEstimated: bool
    totalUsage: 'TotalUsage'
    trace: 'LLMMeshTraceSpan'


# List of all concrete subclasses of com.dataiku.dip.llm.online.LLMClient$SimpleEmbeddingResponse
SimpleEmbeddingResponse = Union[
    '_SimpleEmbeddingResponse',
    'SimpleEmbeddingResponseOrError',
]


# EOF
