(function(){
    'use strict';

    var app = angular.module('dataiku.projects.directives', ['dataiku.filters']);

    app.directive('globalTagsList', function(TaggingService){
        return {
            template: 
        	`<div class="tagsList">
                <ul class="tags vertical-flex">
                    <li ng-repeat="tag in tags" ng-class="{'selected' : isTagSelected(tag)}">
                        <span ng-click="onClick(tag)" style="{{isTagSelected(tag) ? ' background-color:' + getTagColor(tag.title) : ''}}"
                                class="tag flex horizontal-flex" ng-class="{selected: isTagSelected(tag)}"  >
                            <span class="bullet" style="background-color:{{isTagSelected(tag) ? 'white' : getTagColor(tag.title)}};"> </span>
                            <span class="title flex"><span ui-global-tag="tag.title" object-type="'PROJECT'"/></span>
                            <span class="count noflex">{{tag.count}}</span>
                        </span>
                    </li>
                    <li ng-if="!tags.length">
                        <span class="mleft8">No tags available</span>
                    </li>
                </ul>
            </div>`,
            scope: {
            	tags: '=globalTagsList',
            	selectedTags: '=',
                onClickFunc: '='
            },
            link: function(scope, element){
                scope.onClick = function(tag){
                	scope.onClickFunc(tag.title);
                };
                
                scope.isTagSelected = function(tag) {
                	return scope.selectedTags.indexOf(tag.title) > -1;
                }

                scope.getTagColor = TaggingService.getTagColor;
            }
        };
    });
    
    app.directive('projectStatusList', function($location, DKUConstants){
        return {
            template: 
        	'<ul>' +
            '    <li ng-repeat="projectStatus in projectStatusList" ng-if="projectStatus.name != DKUConstants.ARCHIVED_PROJECT_STATUS" ng-click="$event.stopPropagation();toggleProjectStatus(projectStatus);" class="aic project-status" ng-class="{\'selected\' : isProjectStatusSelected(projectStatus.name), \'disabled\' : isProjectStatusSelected(DKUConstants.ARCHIVED_PROJECT_STATUS)}">' +
            '        <span class="status-color" style="background-color:{{projectStatus.color}};"></span> <span class="status-title">{{projectStatus.name}}</span>' +
            '    </li>' +
            '</ul>' + 
            '<button class="btn btn--contained" ng-click="toggleArchive()"><span ng-if="!isProjectStatusSelected(DKUConstants.ARCHIVED_PROJECT_STATUS)">Show archives</span><span ng-if="isProjectStatusSelected( DKUConstants.ARCHIVED_PROJECT_STATUS)">Show non archived</span></button>' +
            '<button class="btn btn--contained" ng-click="manageProjectStatus()">Manage project status</button>',
            scope: {
            	projectStatusList: '=',
            	selectedProjectStatusList: '='
            },
            link: function(scope, element){
            	scope.DKUConstants = DKUConstants;
                scope.toggleProjectStatus = function(projectStatus) {
                	scope.removeArchived();
                	if (projectStatus.name) {
                    	var index = scope.selectedProjectStatusList.indexOf(projectStatus.name);
                    	index > -1 ? scope.selectedProjectStatusList.splice(index, 1) : scope.selectedProjectStatusList.push(projectStatus.name);
                	}
            	}
                
                scope.removeArchived = function() {
                	var archivedIndex = scope.selectedProjectStatusList.indexOf( DKUConstants.ARCHIVED_PROJECT_STATUS);
                	if (archivedIndex != -1) {
                		scope.selectedProjectStatusList.splice(archivedIndex, 1);
                	}
                }
                
                scope.toggleArchive = function() {
                	if (scope.isProjectStatusSelected( DKUConstants.ARCHIVED_PROJECT_STATUS)) {
            			scope.selectedProjectStatusList = [];
                	} else {
                		scope.selectedProjectStatusList = [ DKUConstants.ARCHIVED_PROJECT_STATUS];
                	}
                }
                
                scope.isProjectStatusSelected = function(projectStatusName) {
                	return scope.selectedProjectStatusList.indexOf(projectStatusName) > -1;
                }
                
                scope.manageProjectStatus = function() {
                	$location.path('/admin/general/');
                }
            }
        };
    });

    app.directive('accessLevelList', function() {
        return {
            template:
            `<ul>
                <li ng-click="toggleAccessibleItems()" class="qa_object-list_access-level-widget_list-popover_accessible-item" ng-class="{'selected' : accessibleItemsEnabled, 'disabled' : !accessibleItemsEnabled}"><span class="access-level-title">{{ objectType | niceTaggableType | capitalize }}s you have access to</span></li>
                <li ng-click="toggleLimitedVisibilityItems()" class="qa_object-list_access-level-widget_list-popover_limited-item" ng-class="{'selected' : limitedVisibilityItemsEnabled, 'disabled' : !limitedVisibilityItemsEnabled}"><span class="access-level-title">Discoverable {{ objectType | niceTaggableType}}s you don't have access to</span></li>
            </ul>`,
            scope: {
                objectType: '<',
                accessibleItemsEnabled: '=',
                limitedVisibilityItemsEnabled: '='
            },
            link: function(scope) {
                scope.toggleAccessibleItems = function(){
                    scope.accessibleItemsEnabled = !scope.accessibleItemsEnabled;
                };

                scope.toggleLimitedVisibilityItems = function(){
                    scope.limitedVisibilityItemsEnabled = !scope.limitedVisibilityItemsEnabled;
                };
            }
        };
    });
    
    app.directive('projectStatusSelector', function($state){
        return {
            template: 
        	'<ul>' +
            '    <li ng-repeat="projectStatus in projectStatusList" ng-click="onClick(projectStatus)" class="project-status" ng-class="{\'selected\' : isSelectedFunc(projectStatus)}">' +
            '       <span class="status-color" style="background-color:{{projectStatus.color}};"></span> <span class="status-title">{{projectStatus.name}}</span>' +
            '   </li>' +
            '</ul>' + 
            '<button class="btn btn--contained btn-tag-list" full-click><a main-click ng-click="adminProjetStatus()" style="color:#999;text-decoration:none;">Manage project status</a></button>',
            scope: {
            	projectStatusList: '=projectStatusSelector',
                isSelectedFunc: '=',
                onClickFunc: '='
            },
            link: function(scope, element){
                scope.onClick = function(projectStatus){
                	scope.onClickFunc(projectStatus.name);
                };
                
                scope.adminProjetStatus = function() {
                    $state.go("admin.general.themes");
                }
            }
        };
    });
    
    //contributorsList directive's name already used !
    app.directive('usersList', function(){
        return {
            template: 
            `<div class="noflex search-wrapper" >
                <input type="search" autofocus  placeholder="Find users" ng-model="filterString" />
            </div>
        	<ul class="flex filtered-list"> 
                <li ng-if="customButtonToggleAction" ng-click="customButtonToggleActionFn()" class="contributor" ng-class="{'selected' : isCustomButtonSelected}"><span ng-transclude></span></li> 
                <li ng-repeat="contributor in usersList | filter:matchUsersByDisplayName" ng-click="toggleContributor(contributor)" class="contributor" ng-class="{'selected' : isContributorSelected(contributor)}"> 
                   <span user-picture="contributor.login" size="20"></span>
                   <span class="contributor-name">{{contributor.displayName}}</span>
                   &nbsp;
                   <span class="contributor-login">@{{contributor.login}}</span>
                </li>
            </ul>`,
            scope: {
            	usersList: '=',
                selectedUsersList: '=',
                customButtonToggleAction: '=?',
                onSelect: '&?', // called with user's login
                onUnselect: '&?' // called with user's login
            },
            transclude: true,
            link: function(scope){
                scope.filterString = "";

                scope.matchUsersByDisplayName = function (user){
                    return user.displayName.search(new RegExp(scope.filterString, 'i')) > -1;
                };

                scope.toggleContributor = function(contributor) {
                	if (contributor.login) {
                    	const index = scope.selectedUsersList.indexOf(contributor.login);
                    	index > -1 ? scope.selectedUsersList.splice(index, 1) : scope.selectedUsersList.push(contributor.login);
                        if (scope.onUnselect && typeof scope.onUnselect === 'function' && index > -1) {
                            scope.onUnselect && scope.onUnselect({ login: contributor.login });
                        }
                        if (scope.onSelect && typeof scope.onSelect === 'function' && index <= -1) {
                            scope.onSelect && scope.onSelect({ login: contributor.login });
                        }
                	}
            	}
                
                scope.isContributorSelected = function(contributor) {
                	return scope.selectedUsersList.indexOf(contributor.login) > -1;
                }

                scope.isCustomButtonSelected = false;
                scope.customButtonToggleActionFn = function() {
                    scope.isCustomButtonSelected = ! scope.isCustomButtonSelected;
                    scope.customButtonToggleAction(scope.isCustomButtonSelected);
                }
            }
        };
    });

    app.directive('groupsList', function(){
        return {
            template:
                `<div class="noflex search-wrapper" >
                <input type="search" autofocus  placeholder="Find groups" ng-model="filterString" />
            </div>
        	<ul class="flex filtered-list"> 
                <li ng-repeat="group in groupsList | filter:matchGroup" ng-click="toggleGroup(group)" class="contributor" ng-class="{'selected' : isGroupSelected(group)}"> 
                    <span><i class="icon-group mright8"></i></span><span ng-bind="group" ng-if="group != '$$ALL_USERS$$'"></span><span ng-if="group == '$$ALL_USERS$$'">All users</span>
                </li>
            </ul>`,
            scope: {
                groupsList: '=',
                selectedGroupsList: '=',
                onSelect: '&?', // called with { group: 'the name of the group' }
                onUnselect: '&?' // called with { group: 'the name of the group' }
            },
            transclude: true,
            link: function(scope){
                scope.filterString = "";

                scope.matchGroup = function (group){
                    return group.search(new RegExp(scope.filterString, 'i')) > -1;
                };

                scope.toggleGroup = function(group) {
                    const index = scope.selectedGroupsList.indexOf(group);
                    index > -1 ? scope.selectedGroupsList.splice(index, 1) : scope.selectedGroupsList.push(group);
                    if (scope.onUnselect && typeof scope.onUnselect === 'function' && index > -1) {
                        scope.onUnselect && scope.onUnselect({ group: group });
                    }
                    if (scope.onSelect && typeof scope.onSelect === 'function' && index <= -1) {
                        scope.onSelect && scope.onSelect({ group: group });
                    }
                }

                scope.isGroupSelected = function(group) {
                    return scope.selectedGroupsList.indexOf(group) > -1;
                }
            }
        };
    });

    app.directive("codeEnvOverrideForm", function (DataikuAPI, $stateParams) {
        return {
          restrict: 'A',
          templateUrl: '/templates/projects/code-env-override-form.html',
          scope: {
            envSelection: '=codeEnvOverrideForm',
            envLang: '=',
          },
          link: function ($scope) {
            $scope.envNamesWithDescs = [];
            function selectDefault () {
              if (
                $scope.envSelection.mode === "EXPLICIT_ENV" &&
                $scope.envSelection.envName === undefined &&
                $scope.envNamesWithDescs !== null &&
                $scope.envNamesWithDescs.length > 0
              ) {
                $scope.envSelection.envName = $scope.envNamesWithDescs[0].envName;
              } else if($scope.envSelection.mode !== "EXPLICIT_ENV") {
                $scope.envSelection.envName = undefined;
              }
            };
            DataikuAPI.codeenvs
              .listNamesWithDefault($scope.envLang, $stateParams.projectKey)
              .success(function (data) {
                $scope.envNamesWithDescs = data.envs;
                selectDefault();
              })
              .error(setErrorInScope.bind($scope));
            function setSelectedEnv() {
                if ($scope.envNamesWithDescs) {
                    $scope.selectedEnv = $scope.envNamesWithDescs.filter(e=>e.envName === $scope.envSelection.envName)[0];
                }
            }
            $scope.$watchGroup(["envSelection.envName", "envNamesWithDescs.envs"], setSelectedEnv);
            $scope.$watch("envSelection.mode", selectDefault);
          },
        };
      });

})();