(function() {
    'use strict';

    angular.module('dataiku.charts')
        .factory('LinesBrushDrawer', LinesBrushDrawer);

    // (!) This service previously was in static/dataiku/js/simple_report/curves/lines.js
    function LinesBrushDrawer(LinesUtils, ChartAxesUtils, ChartYAxisPosition, ChartDimension, ReferenceLines) {
        return function(g, chartDef, chartData, chartBase, linesData, facetIndex, brushAxes, referenceLinesValues = undefined) {

            const xDimension = ChartDimension.getGenericDimension(chartDef);
            const emptyBinsMode = xDimension.numParams.emptyBinsMode;
            const xLabels = chartData.getAxisLabels('x');
            const leftYAxisID = ChartAxesUtils.computeYAxisID(ChartYAxisPosition.LEFT);
            const rightYAxisID = ChartAxesUtils.computeYAxisID(ChartYAxisPosition.RIGHT);
            const xAxis = brushAxes.x;
            const leftYAxis = brushAxes[leftYAxisID];
            const rightYAxis = brushAxes[rightYAxisID];

            const wrappers = LinesUtils.drawWrappers(chartDef, chartBase, linesData, g, false, false, 'brush-wrapper');

            LinesUtils.drawPoints(chartDef, chartBase, chartData, facetIndex, wrappers, xAxis, xLabels, leftYAxis, rightYAxis, xDimension, emptyBinsMode, 1);

            const [, lineGs, lineDashGs] = LinesUtils.configureLines(chartDef, chartData, facetIndex, wrappers, undefined, xAxis, leftYAxis, rightYAxis, xDimension, xLabels, emptyBinsMode);

            LinesUtils.drawPaths(chartDef, chartBase, chartData, facetIndex, lineGs, xDimension, xLabels, xAxis, leftYAxis, rightYAxis, emptyBinsMode, false, false, 1, lineDashGs);

            if (referenceLinesValues) {
                const yAxes = [];
                if (leftYAxis) {
                    const isPercentScaleOnYAxis = chartDef.genericMeasures.some(measure => measure.displayAxis === 'axis1' && ChartDimension.isPercentScale([measure]));
                    const leftYFormattingOptions = ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting, leftYAxis.id);
                    yAxes.push({ ...leftYAxis, isPercentScale: isPercentScaleOnYAxis, formattingOptions: leftYFormattingOptions });
                }
                if (rightYAxis) {
                    const isPercentScaleOnY2Axis = chartDef.genericMeasures.some(measure => measure.displayAxis !== 'axis1' && ChartDimension.isPercentScale([measure]));
                    const rightYFormattingOptions = ChartAxesUtils.getYAxisNumberFormatting(chartDef.yAxesFormatting, rightYAxis.id);
                    yAxes.push({ ...rightYAxis, isPercentScale: isPercentScaleOnY2Axis, formattingOptions: rightYFormattingOptions });
                }

                const displayedReferenceLines = ReferenceLines.getDisplayedReferenceLines(chartDef.referenceLines, chartDef.$axisSpecs && chartDef.$axisSpecs.x, chartDef.$axisSpecs && chartDef.$axisSpecs.y);
                ReferenceLines.drawReferenceLines(
                    d3.select(wrappers[0][wrappers[0].length-1]),
                    chartBase.vizWidth,
                    chartBase.vizHeight,
                    xAxis,
                    yAxes,
                    displayedReferenceLines,
                    referenceLinesValues,
                    null,
                    true // in brush
                );
            }
        };
    }

})();
