/* global describe, beforeEach, module, inject, it, expect */

describe("TableListingModeState", function() {
    let tableListingModeState;

    beforeEach(() => {
        module('dataiku.notebooks.sql', function () {});

        inject(function (TableListingModeState) {
            tableListingModeState = TableListingModeState;
        });
    });

    describe("subscription", function () {
        it("gets existing value if any and then gets updates", function () {
            tableListingModeState.setMode("PROJECT");

            const listenerCalls = []
            const listener = (currentMode) => {
                listenerCalls.push(currentMode);
            }

            tableListingModeState.subscribe(listener);

            expect(listenerCalls.length).toBe(1);
            expect(listenerCalls[0]).toBe("PROJECT");

            tableListingModeState.setMode("ALL");

            expect(listenerCalls.length).toBe(2);
            expect(listenerCalls[1]).toBe("ALL");

            tableListingModeState.setMode("PROJECT");

            expect(listenerCalls.length).toBe(3);
            expect(listenerCalls[2]).toBe("PROJECT");
        });

        it("gets no value if no previous and then gets updates", function () {
            const listenerCalls = []
            const listener = (currentMode) => {
                listenerCalls.push(currentMode);
            }

            tableListingModeState.subscribe(listener);

            expect(listenerCalls.length).toBe(0);

            tableListingModeState.setMode("ALL");

            expect(listenerCalls.length).toBe(1);
            expect(listenerCalls[0]).toBe("ALL");

            tableListingModeState.setMode("PROJECT");

            expect(listenerCalls.length).toBe(2);
            expect(listenerCalls[1]).toBe("PROJECT");
        });

        it("can be unsubscribed", function () {
            const listenerCalls = []
            const listener = (currentMode) => {
                listenerCalls.push(currentMode);
            }

            const unsubscribe = tableListingModeState.subscribe(listener);

            expect(listenerCalls.length).toBe(0);

            tableListingModeState.setMode("PROJECT");

            expect(listenerCalls.length).toBe(1);
            expect(listenerCalls[0]).toBe("PROJECT");

            tableListingModeState.setMode("ALL");

            expect(listenerCalls.length).toBe(2);
            expect(listenerCalls[1]).toBe("ALL");

            unsubscribe();

            tableListingModeState.setMode("PROJECT");
            tableListingModeState.setMode("ALL");
            tableListingModeState.setMode("PROJECT");

            expect(listenerCalls.length).toBe(2);
            expect(listenerCalls[1]).toBe("ALL");
        });
    });
});