(function() {
    'use strict';

    angular.module('dataiku.workspaces')
        .directive('workspaceObjectRightColumnSummary', workspaceObjectRightColumnSummary);

    /**
     * Directive used by the standardizedSidePanel to display information about workspace objects
     */
    function workspaceObjectRightColumnSummary(DataikuAPI, $controller, QuickView, ActivityIndicator, StateUtils) {
        return {
            templateUrl: '/static/dataiku/workspaces/workspace-object-right-column-summary/workspace-object-right-column-summary.directive.html',
            link: function($scope) {
                $controller('_TaggableObjectsMassActions', { $scope });

                function initialize() {
                    const type = $scope.selection.selectedObject.type;
                    $scope.objectFullInfo = {
                        [type.toLowerCase()]: $scope.selection.selectedObject
                    };
                }

                function getFullInfo() {
                    const { type, projectKey, id } = $scope.selection.selectedObject;
                    switch (type) {
                        case 'DATASET':
                            return DataikuAPI.datasets.getPublicInfo(projectKey, projectKey, id);
                        case 'DASHBOARD':
                            return DataikuAPI.dashboards.getFullInfo(projectKey, id);
                        case 'ARTICLE':
                            return DataikuAPI.wikis.getArticleSummary(projectKey, id);
                        case 'WEB_APP':
                            return DataikuAPI.webapps.getPublicInfo(projectKey, id);
                        default:
                            throw new Error(`Unknown type ${type}`);
                    }
                }

                function saveObject() {
                    const type = $scope.selection.selectedObject.type;
                    switch (type) {
                        case 'DATASET':
                            return DataikuAPI.datasets.save($scope.selection.selectedObject.projectKey, $scope.objectFullInfo.dataset);
                        case 'DASHBOARD':
                            return DataikuAPI.dashboards.save($scope.objectFullInfo.dashboard);
                        case 'ARTICLE':
                            return DataikuAPI.wikis.saveArticle($scope.objectFullInfo.object);
                        case 'WEB_APP':
                            return DataikuAPI.webapps.save($scope.objectFullInfo.webapp);
                        default:
                            throw new Error(`Unknown type ${type}`);
                    }
                }

                $scope.QuickView = QuickView;
                $scope.StateUtils = StateUtils;

                const hasDetailsTab = $scope.displayedTabs.some(tab => tab.name === 'details');

                if (hasDetailsTab) {
                    $scope.$on('objectSummaryEdited', () => {
                        saveObject()
                            .success(() => ActivityIndicator.success('Saved'))
                            .error(setErrorInScope.bind($scope));
                    });

                    $scope.refreshData = () => {
                        getFullInfo()
                            .success(data => {
                                $scope.objectFullInfo = data;
                                if ($scope.selection.selectedObject.interest) {
                                    // Override with interest local to the workspace
                                    $scope.objectFullInfo.interest = $scope.selection.selectedObject.interest;
                                }
                            })
                            .error(setErrorInScope.bind($scope));
                    };

                    $scope.$on('customFieldsSaved', $scope.refreshData);

                    initialize();
                    $scope.refreshData();
                }
            }
        };
    }
}());
