from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .inline_document_ref import InlineDocumentRef, _InlineDocumentRef
    from .local_file_document_ref import LocalFileDocumentRef, _LocalFileDocumentRef
    from .managed_folder_document_ref import ManagedFolderDocumentRef, _ManagedFolderDocumentRef
    from .tmp_document_ref import TmpDocumentRef, _TmpDocumentRef

'''
Translated from class com.dataiku.dip.docextraction.common.InputRefs$DocumentRef
Via: PyModel annotation in the class hierarchy
'''


class _DocumentRef(TypedDict):
    mimeType: str


# List of all concrete subclasses of com.dataiku.dip.docextraction.common.InputRefs$DocumentRef
DocumentRef = Union[
    'InlineDocumentRef',
    'LocalFileDocumentRef',
    'ManagedFolderDocumentRef',
    'TmpDocumentRef',
]

# Types of class com.dataiku.dip.docextraction.common.InputRefs$DocumentRef in PolyJSON mappings (as literal type)
DocumentRefTypeLiteral = Literal["inline_document", "local_file", "managed_folder", "tmp_file", ]


# EOF
