from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from ..all_filter.all_filter import AllFilter, _AllFilter
    from ..and_filter.and_filter import AndFilter, _AndFilter
    from ..anum_filter.anum_filter import AnumFilter, _AnumFilter
    from ..interval_filter.interval_filter import IntervalFilter, _IntervalFilter
    from ..missing_value_filter.missing_value_filter import MissingValueFilter, _MissingValueFilter
    from ..not_filter.not_filter import NotFilter, _NotFilter
from .....utils.immutable_value_object.immutable_value_object import ImmutableValueObject, _ImmutableValueObject

'''
Translated from class com.dataiku.dip.eda.compute.filtering.Filter
Via: com.dataiku.dip.eda.compute.grouping.SubsetGrouping
'''


class _Filter(_ImmutableValueObject, TypedDict):
    name: NotRequired[Optional[str]]


# List of all concrete subclasses of com.dataiku.dip.eda.compute.filtering.Filter
Filter = Union[
    'AllFilter',
    'AndFilter',
    'AnumFilter',
    'IntervalFilter',
    'MissingValueFilter',
    'NotFilter',
]

# Types of class com.dataiku.dip.eda.compute.filtering.Filter in PolyJSON mappings (as literal type)
FilterTypeLiteral = Literal["all", "and", "anum", "interval", "missing", "not", ]


# EOF
