from typing import List, Dict, Any, Optional, TypeVar, Generic, Union, TYPE_CHECKING
from dataiku.generated_sources._typing import TypedDict, Literal, Final, NotRequired
if TYPE_CHECKING:
    from .faithfulness_settings import FaithfulnessSettings, _FaithfulnessSettings
    from .relevancy_settings import RelevancySettings, _RelevancySettings

'''
Translated from class com.dataiku.dip.llm.retrieval.RAGLLMSettings$GuardrailsSettings
Via: PyModel annotation in the class hierarchy
'''


class _GuardrailsSettings(TypedDict):
    embeddingModelId: NotRequired[Optional[str]]
    faithfulnessSettings: 'FaithfulnessSettings'
    llmId: NotRequired[Optional[str]]
    multimodalFaithfulnessSettings: 'FaithfulnessSettings'
    multimodalRelevancySettings: 'RelevancySettings'
    relevancySettings: 'RelevancySettings'


GuardrailsSettings = _GuardrailsSettings


# EOF
