from .blocks.mandatory_tool_call import MandatoryToolCallBlockHandler
from .blocks.emit_output import EmitOutputBlockHandler
from .blocks.context_compression import ContextCompressionBlockHandler
from .blocks.generate_artifact import GenerateArtifactBlockHandler
from .blocks.llm_request import LLMRequestBlockHandler

from .blocks.delegate_to_other_agent import DelegateToOtherAgentBlockHandler
from .blocks.manual_tool_call import ManualToolCallBlockHandler
from .blocks.python import PythonCodeBlockHandler
from .blocks.set_state_entries import SetStateEntriesBlockHandler
from .blocks.set_scratchpad_entries import SetScratchpadEntriesBlockHandler
from .blocks.standard_react import ReactBlockHandler
from .blocks.routing import RoutingBlockHandler
from .blocks.parallel import ParallelBlockHandler
from .blocks.reflection import ReflectionBlockHandler
from .blocks.for_each import ForEachBlockHandler

import logging

def build_block_handler(turn, block_definitions, block_id, sequence_context):
    for block in block_definitions:
        if block["id"] == block_id:
            if block["type"] == "STANDARD_REACT":
                return ReactBlockHandler(turn, sequence_context, block)
            elif block["type"] == "LLM_REQUEST":
                return LLMRequestBlockHandler(turn, sequence_context, block)
            elif block["type"] == "DELEGATE_TO_OTHER_AGENT":
                return DelegateToOtherAgentBlockHandler(turn, sequence_context, block)

            elif block["type"] == "ROUTING":
                return RoutingBlockHandler(turn, sequence_context, block)
            elif block["type"] == "FOR_EACH":
                return ForEachBlockHandler(turn, sequence_context, block)
            elif block["type"] == "PARALLEL":
                return ParallelBlockHandler(turn, sequence_context, block)

            elif block["type"] == "SET_STATE_ENTRIES":
                return SetStateEntriesBlockHandler(turn, sequence_context, block)
            elif block["type"] == "SET_SCRATCHPAD_ENTRIES":
                return SetScratchpadEntriesBlockHandler(turn, sequence_context, block)
            elif block["type"] == "EMIT_OUTPUT":
                return EmitOutputBlockHandler(turn, sequence_context, block)
            elif block["type"] == "CONTEXT_COMPRESSION":
                return ContextCompressionBlockHandler(turn, sequence_context, block)
            elif block["type"] == "GENERATE_ARTIFACT":
                return GenerateArtifactBlockHandler(turn, sequence_context, block)
            elif block["type"] == "EDIT_LAST_USER_MESSAGE":
                raise Exception("EDIT_LAST_USER_MESSAGE block type not implemented yet")
            elif block["type"] == "PYTHON_CODE":
                return PythonCodeBlockHandler(turn, sequence_context, block)
            elif block["type"] == "MANDATORY_TOOL_CALL":
                return MandatoryToolCallBlockHandler(turn, sequence_context, block)
            elif block["type"] == "MANUAL_TOOL_CALL":
                return ManualToolCallBlockHandler(turn, sequence_context, block)
            elif block["type"] == "REFLECTION":
                return ReflectionBlockHandler(turn, sequence_context, block)

            elif block["type"] == "CUSTOM":
                import sys
                logging.info("Sys path: %s" % sys.path)
                type = block.get("componentId", "")
                clazz = turn.agent.config["customBlockClassNames"].get(type, None)
                if clazz is None:
                    raise Exception("No class configured for custom block type: %s - known types: %s" % (type, list(turn.agent.config["customBlockClassNames"].keys())))

                import importlib
                module_path, class_name = clazz.rsplit('.', 1)
                module = importlib.import_module(module_path)
                cls = getattr(module, class_name)
                return cls(turn, sequence_context, block)

            else:
                raise Exception("Invalid block type: %s" % block["type"])

    raise Exception("Block id %s not found" % block_id)
