/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.metastore;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.glue.catalog.metastore.AWSCredentialsProviderFactory;
import com.amazonaws.internal.StaticCredentialsProvider;
import com.google.common.base.Preconditions;
import org.apache.hadoop.conf.Configuration;

public class SessionCredentialsProviderFactory
implements AWSCredentialsProviderFactory {
    public static final String AWS_ACCESS_KEY_CONF_VAR = "hive.aws_session_access_id";
    public static final String AWS_SECRET_KEY_CONF_VAR = "hive.aws_session_secret_key";
    public static final String AWS_SESSION_TOKEN_CONF_VAR = "hive.aws_session_token";

    @Override
    public AWSCredentialsProvider buildAWSCredentialsProvider(Configuration conf) {
        Preconditions.checkArgument((conf != null ? 1 : 0) != 0, (Object)"conf cannot be null.");
        String accessKey = conf.get(AWS_ACCESS_KEY_CONF_VAR);
        String secretKey = conf.get(AWS_SECRET_KEY_CONF_VAR);
        String sessionToken = conf.get(AWS_SESSION_TOKEN_CONF_VAR);
        Preconditions.checkArgument((accessKey != null ? 1 : 0) != 0, (Object)"hive.aws_session_access_id must be set.");
        Preconditions.checkArgument((secretKey != null ? 1 : 0) != 0, (Object)"hive.aws_session_secret_key must be set.");
        Preconditions.checkArgument((sessionToken != null ? 1 : 0) != 0, (Object)"hive.aws_session_token must be set.");
        BasicSessionCredentials credentials = new BasicSessionCredentials(accessKey, secretKey, sessionToken);
        return new StaticCredentialsProvider((AWSCredentials)credentials);
    }
}

