/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands.merge;

import java.io.Serializable;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Column$;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Dataset$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.And;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.expressions.NamedExpression;
import org.apache.spark.sql.catalyst.expressions.Or;
import org.apache.spark.sql.catalyst.expressions.Or$;
import org.apache.spark.sql.catalyst.plans.logical.DeltaMergeIntoClause;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.delta.DeltaUDF$;
import org.apache.spark.sql.delta.MaterializedRowCommitVersion$;
import org.apache.spark.sql.delta.MaterializedRowId$;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.RowTracking$;
import org.apache.spark.sql.delta.actions.AddCDCFile;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.FileAction;
import org.apache.spark.sql.delta.commands.DMLWithDeletionVectorsHelper$;
import org.apache.spark.sql.delta.commands.DeletionVectorBitmapGenerator$;
import org.apache.spark.sql.delta.commands.DeletionVectorResult;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.MergeIntoCommandBase;
import org.apache.spark.sql.delta.commands.MergeIntoCommandBase$;
import org.apache.spark.sql.delta.commands.TouchedFileWithDV;
import org.apache.spark.sql.delta.commands.cdc.CDCReader$;
import org.apache.spark.sql.delta.commands.merge.DeduplicateCDFDeletes;
import org.apache.spark.sql.delta.commands.merge.MergeIntoMaterializeSource;
import org.apache.spark.sql.delta.commands.merge.MergeOutputGeneration;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex;
import org.apache.spark.sql.delta.files.TahoeBatchFileIndex$;
import org.apache.spark.sql.delta.implicits.package$;
import org.apache.spark.sql.delta.util.SetAccumulator;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.expressions.UserDefinedFunction;
import org.apache.spark.sql.functions$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.IndexedSeq;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001da\u0001\u0003\u0005\n!\u0003\r\t\u0001G>\t\u000b\r\u0002A\u0011\u0001\u0013\t\u000b!\u0002A\u0011C\u0015\t\u000b5\u0003A\u0011\u0003(\t\u000b\t\u0004A\u0011C2\t\u000b\u0011\u0004A\u0011C2\t\u000b\u0015\u0004A\u0011\u00034\t\u000bY\u0004A\u0011C<\u0003)\rc\u0017m]:jG6+'oZ3Fq\u0016\u001cW\u000f^8s\u0015\tQ1\"A\u0003nKJ<WM\u0003\u0002\r\u001b\u0005A1m\\7nC:$7O\u0003\u0002\u000f\u001f\u0005)A-\u001a7uC*\u0011\u0001#E\u0001\u0004gFd'B\u0001\n\u0014\u0003\u0015\u0019\b/\u0019:l\u0015\t!R#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002-\u0005\u0019qN]4\u0004\u0001M\u0019\u0001!G\u0010\u0011\u0005iiR\"A\u000e\u000b\u0003q\tQa]2bY\u0006L!AH\u000e\u0003\r\u0005s\u0017PU3g!\t\u0001\u0013%D\u0001\n\u0013\t\u0011\u0013BA\u000bNKJ<WmT;uaV$x)\u001a8fe\u0006$\u0018n\u001c8\u0002\r\u0011Jg.\u001b;%)\u0005)\u0003C\u0001\u000e'\u0013\t93D\u0001\u0003V]&$\u0018\u0001\u00054j]\u0012$v.^2iK\u00124\u0015\u000e\\3t)\rQ#i\u0012\t\u00055-js(\u0003\u0002-7\t1A+\u001e9mKJ\u00022A\f\u001c:\u001d\tyCG\u0004\u00021g5\t\u0011G\u0003\u00023/\u00051AH]8pizJ\u0011\u0001H\u0005\u0003km\tq\u0001]1dW\u0006<W-\u0003\u00028q\t\u00191+Z9\u000b\u0005UZ\u0002C\u0001\u001e>\u001b\u0005Y$B\u0001\u001f\u000e\u0003\u001d\t7\r^5p]NL!AP\u001e\u0003\u000f\u0005#GMR5mKB\u0011\u0001\u0005Q\u0005\u0003\u0003&\u0011Q\u0003R3ekBd\u0017nY1uK\u000e#e\tR3mKR,7\u000fC\u0003\u0013\u0005\u0001\u00071\t\u0005\u0002E\u000b6\tq\"\u0003\u0002G\u001f\ta1\u000b]1sWN+7o]5p]\")\u0001J\u0001a\u0001\u0013\u0006AA-\u001a7uCRCh\u000e\u0005\u0002K\u00176\tQ\"\u0003\u0002M\u001b\t)r\n\u001d;j[&\u001cH/[2Ue\u0006t7/Y2uS>t\u0017!E2mCV\u001cX\rR5tUVt7\r^5p]R\u0011qj\u0016\t\u0003!Vk\u0011!\u0015\u0006\u0003%N\u000b1\"\u001a=qe\u0016\u001c8/[8og*\u0011AkD\u0001\tG\u0006$\u0018\r\\=ti&\u0011a+\u0015\u0002\u000b\u000bb\u0004(/Z:tS>t\u0007\"\u0002-\u0004\u0001\u0004I\u0016aB2mCV\u001cXm\u001d\t\u0004]YR\u0006CA.a\u001b\u0005a&BA/_\u0003\u001dawnZ5dC2T!aX*\u0002\u000bAd\u0017M\\:\n\u0005\u0005d&\u0001\u0006#fYR\fW*\u001a:hK&sGo\\\"mCV\u001cX-A\u000fhK:,'/\u0019;f\r&dG/\u001a:G_Jlu\u000eZ5gS\u0016$'k\\<t)\u0005y\u0015\u0001G4f]\u0016\u0014\u0018\r^3GS2$XM\u001d$pe:+wOU8xg\u0006yqO]5uK\u0006cGn\u00115b]\u001e,7\u000f\u0006\u0004hW2lw.\u001d\t\u0004]YB\u0007C\u0001\u001ej\u0013\tQ7H\u0001\u0006GS2,\u0017i\u0019;j_:DQA\u0005\u0004A\u0002\rCQ\u0001\u0013\u0004A\u0002%CQA\u001c\u0004A\u00025\naBZ5mKN$vNU3xe&$X\rC\u0003q\r\u0001\u0007q(A\u000beK\u0012,\b\u000f\\5dCR,7\t\u0012$EK2,G/Z:\t\u000bI4\u0001\u0019A:\u0002']\u0014\u0018\u000e^3V]6|G-\u001b4jK\u0012\u0014vn^:\u0011\u0005i!\u0018BA;\u001c\u0005\u001d\u0011un\u001c7fC:\f\u0001b\u001e:ji\u0016$ek\u001d\u000b\u0005ObL(\u0010C\u0003\u0013\u000f\u0001\u00071\tC\u0003I\u000f\u0001\u0007\u0011\nC\u0003o\u000f\u0001\u0007QFE\u0002}}~4A! \u0001\u0001w\naAH]3gS:,W.\u001a8u}A\u0011\u0001\u0005\u0001\t\u0005\u0003\u0003\t\u0019!D\u0001\f\u0013\r\t)a\u0003\u0002\u0015\u001b\u0016\u0014x-Z%oi>\u001cu.\\7b]\u0012\u0014\u0015m]3")
public interface ClassicMergeExecutor
extends MergeOutputGeneration {
    public static /* synthetic */ Tuple2 findTouchedFiles$(ClassicMergeExecutor $this, SparkSession spark, OptimisticTransaction deltaTxn) {
        return $this.findTouchedFiles(spark, deltaTxn);
    }

    default public Tuple2<Seq<AddFile>, DeduplicateCDFDeletes> findTouchedFiles(SparkSession spark, OptimisticTransaction deltaTxn) {
        return (Tuple2)((MergeIntoCommandBase)((Object)this)).recordMergeOperation("findTouchedFiles", "MERGE operation - scanning files for matches", "scanTimeMs", (Function0 & Serializable & scala.Serializable)() -> {
            Function2 columnComparator = spark.sessionState().analyzer().resolver();
            SetAccumulator touchedFilesAccum = new SetAccumulator();
            spark.sparkContext().register(touchedFilesAccum, MergeIntoCommandBase$.MODULE$.TOUCHED_FILES_ACCUM_NAME());
            Seq<AddFile> dataSkippedFiles = ((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses().isEmpty() ? deltaTxn.filterFiles(((MergeIntoCommandBase)((Object)this)).getTargetOnlyPredicates(spark), true) : deltaTxn.filterFiles((Seq<Expression>)((Seq)new .colon.colon((Object)Literal$.MODULE$.TrueLiteral(), (List)Nil$.MODULE$)), true);
            String joinType = ((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses().isEmpty() ? "inner" : "right_outer";
            Literal matchedPredicate = ((MergeIntoCommandBase)((Object)this)).isMatchedOnly() ? (Expression)((TraversableOnce)((MergeIntoCommandBase)((Object)this)).matchedClauses().map((Function1 & Serializable & scala.Serializable)x$1 -> (Expression)x$1.condition().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.TrueLiteral()), Seq$.MODULE$.canBuildFrom())).reduce((Function2 & Serializable & scala.Serializable)(a, b) -> new Or(a, b)) : Literal$.MODULE$.TrueLiteral();
            Iterable targetColsNeeded = (Iterable)((TraversableLike)((TraversableLike)((MergeIntoCommandBase)((Object)this)).condition().references().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.name(), Iterable$.MODULE$.canBuildFrom())).$plus$plus(deltaTxn.snapshot().metadata().partitionColumns(), Iterable$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)matchedPredicate.references().map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.name(), Iterable$.MODULE$.canBuildFrom()), Iterable$.MODULE$.canBuildFrom());
            Seq columnsToDrop = (Seq)((TraversableLike)deltaTxn.snapshot().metadata().schema().map((Function1 & Serializable & scala.Serializable)x$4 -> x$4.name(), Seq$.MODULE$.canBuildFrom())).filterNot((Function1 & Serializable & scala.Serializable)field -> BoxesRunTime.boxToBoolean((boolean)targetColsNeeded.exists((Function1 & Serializable & scala.Serializable)name -> BoxesRunTime.boxToBoolean((boolean)ClassicMergeExecutor.$anonfun$findTouchedFiles$9(columnComparator$1, field, name)))));
            Expression incrSourceRowCountExpr = ((MergeIntoCommandBase)((Object)this)).incrementMetricAndReturnBool("numSourceRows", true);
            Dataset sourceDF = ((MergeIntoMaterializeSource)((Object)this)).getMergeSource().df().withColumn(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL(), Column$.MODULE$.apply(incrSourceRowCountExpr)).filter(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL()).drop(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL());
            LogicalPlan targetPlan = ((MergeIntoCommandBase)((Object)this)).buildTargetPlanWithFiles(spark, deltaTxn, dataSkippedFiles, (Seq<String>)columnsToDrop);
            Dataset targetDF = Dataset$.MODULE$.ofRows(spark, targetPlan).withColumn(MergeIntoCommandBase$.MODULE$.ROW_ID_COL(), functions$.MODULE$.monotonically_increasing_id()).withColumn(MergeIntoCommandBase$.MODULE$.FILE_NAME_COL(), functions$.MODULE$.input_file_name());
            Dataset joinToFindTouchedFiles = sourceDF.join(targetDF, Column$.MODULE$.apply(((MergeIntoCommandBase)((Object)this)).condition()), joinType);
            UserDefinedFunction recordTouchedFileName = DeltaUDF$.MODULE$.intFromStringBoolean((Function2<String, Object, Object>)(Function2 & Serializable & scala.Serializable)(fileName, shouldRecord) -> BoxesRunTime.boxToInteger((int)ClassicMergeExecutor.$anonfun$findTouchedFiles$10(touchedFilesAccum, fileName, BoxesRunTime.unboxToBoolean((Object)shouldRecord)))).asNondeterministic();
            Dataset collectTouchedFiles = joinToFindTouchedFiles.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(MergeIntoCommandBase$.MODULE$.ROW_ID_COL()), recordTouchedFileName.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col(MergeIntoCommandBase$.MODULE$.FILE_NAME_COL()), Column$.MODULE$.apply((Expression)matchedPredicate)})).as("one")}));
            Dataset matchedRowCounts = collectTouchedFiles.groupBy(MergeIntoCommandBase$.MODULE$.ROW_ID_COL(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[0])).agg(functions$.MODULE$.sum("one").as("count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[0]));
            Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])matchedRowCounts.filter("count > 1").select((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.count(Column$.MODULE$.apply("*")), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))})), functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.sum("count"), functions$.MODULE$.lit((Object)BoxesRunTime.boxToInteger((int)0))}))})).as(package$.MODULE$.longLongEncoder()).collect())).head();
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            long multipleMatchCount = tuple2._1$mcJ$sp();
            long multipleMatchSum = tuple2._2$mcJ$sp();
            Tuple2.mcJJ.sp sp2 = new Tuple2.mcJJ.sp(multipleMatchCount, multipleMatchSum);
            long multipleMatchCount2 = sp2._1$mcJ$sp();
            long multipleMatchSum2 = sp2._2$mcJ$sp();
            boolean hasMultipleMatches = multipleMatchCount2 > 0L;
            ((MergeIntoCommandBase)((Object)this)).throwErrorOnMultipleMatches(hasMultipleMatches, spark);
            if (hasMultipleMatches) {
                long duplicateCount = multipleMatchSum2 - multipleMatchCount2;
                ((MergeIntoCommandBase)((Object)this)).multipleMatchDeleteOnlyOvercount_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)duplicateCount)));
            }
            Seq touchedFileNames = ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter(touchedFilesAccum.value().iterator()).asScala()).toSeq();
            ((Logging)this).logTrace((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(34).append("findTouchedFiles: matched files:\n\t").append(touchedFileNames.mkString("\n\t")).toString());
            Map<String, AddFile> nameToAddFileMap = ((DeltaCommand)((Object)this)).generateCandidateFileMap(((MergeIntoCommandBase)((Object)this)).targetDeltaLog().dataPath(), dataSkippedFiles);
            Seq touchedAddFiles = (Seq)touchedFileNames.map((Function1 & Serializable & scala.Serializable)x$6 -> ((DeltaCommand)((Object)this)).getTouchedFile(((MergeIntoCommandBase)((Object)this)).targetDeltaLog().dataPath(), (String)x$6, nameToAddFileMap), Seq$.MODULE$.canBuildFrom());
            if (((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numSourceRows")).value() == 0L && (dataSkippedFiles.isEmpty() || dataSkippedFiles.forall((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClassicMergeExecutor.$anonfun$findTouchedFiles$13(x$7))))) {
                long numSourceRows = sourceDF.count();
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numSourceRows")).set(numSourceRows);
            }
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetFilesBeforeSkipping")).$plus$eq(deltaTxn.snapshot().numOfFiles());
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetBytesBeforeSkipping")).$plus$eq(deltaTxn.snapshot().sizeInBytes());
            Tuple2<Object, Object> tuple22 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(dataSkippedFiles);
            if (tuple22 == null) {
                throw new MatchError(tuple22);
            }
            long afterSkippingBytes = tuple22._1$mcJ$sp();
            int afterSkippingPartitions = tuple22._2$mcI$sp();
            Tuple2.mcJI.sp sp3 = new Tuple2.mcJI.sp(afterSkippingBytes, afterSkippingPartitions);
            long afterSkippingBytes2 = sp3._1$mcJ$sp();
            int afterSkippingPartitions2 = sp3._2$mcI$sp();
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetFilesAfterSkipping")).$plus$eq((long)dataSkippedFiles.size());
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetBytesAfterSkipping")).$plus$eq(afterSkippingBytes2);
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetPartitionsAfterSkipping")).$plus$eq((long)afterSkippingPartitions2);
            Tuple2<Object, Object> tuple23 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)touchedAddFiles);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            long removedBytes = tuple23._1$mcJ$sp();
            int removedPartitions = tuple23._2$mcI$sp();
            Tuple2.mcJI.sp sp4 = new Tuple2.mcJI.sp(removedBytes, removedPartitions);
            long removedBytes2 = sp4._1$mcJ$sp();
            int removedPartitions2 = sp4._2$mcI$sp();
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetFilesRemoved")).$plus$eq((long)touchedAddFiles.size());
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetBytesRemoved")).$plus$eq(removedBytes2);
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetPartitionsRemovedFrom")).$plus$eq((long)removedPartitions2);
            DeduplicateCDFDeletes dedupe = new DeduplicateCDFDeletes(hasMultipleMatches && ((MergeIntoCommandBase)((Object)this)).isCdcEnabled(deltaTxn), ((MergeIntoCommandBase)((Object)this)).includesInserts());
            return new Tuple2((Object)touchedAddFiles, (Object)dedupe);
        });
    }

    public static /* synthetic */ Expression clauseDisjunction$(ClassicMergeExecutor $this, Seq clauses) {
        return $this.clauseDisjunction((Seq<DeltaMergeIntoClause>)clauses);
    }

    default public Expression clauseDisjunction(Seq<DeltaMergeIntoClause> clauses) {
        Predef$.MODULE$.require(clauses.nonEmpty());
        return (Expression)((TraversableOnce)clauses.map((Function1 & Serializable & scala.Serializable)x$10 -> (Expression)x$10.condition().getOrElse((Function0 & Serializable & scala.Serializable)() -> Literal$.MODULE$.TrueLiteral()), Seq$.MODULE$.canBuildFrom())).reduceLeft((Function2)Or$.MODULE$);
    }

    public static /* synthetic */ Expression generateFilterForModifiedRows$(ClassicMergeExecutor $this) {
        return $this.generateFilterForModifiedRows();
    }

    default public Expression generateFilterForModifiedRows() {
        Literal literal;
        And matchedExpression;
        Object object = matchedExpression = ((MergeIntoCommandBase)((Object)this)).matchedClauses().nonEmpty() ? new And(Column$.MODULE$.apply(((MergeIntoCommandBase)((Object)this)).condition()).expr(), this.clauseDisjunction(((MergeIntoCommandBase)((Object)this)).matchedClauses())) : Literal$.MODULE$.FalseLiteral();
        if (((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses().nonEmpty()) {
            Expression combinedClauses = this.clauseDisjunction(((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses());
            literal = new And(functions$.MODULE$.col(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL()).isNull().expr(), combinedClauses);
        } else {
            literal = Literal$.MODULE$.FalseLiteral();
        }
        Literal notMatchedBySourceExpression = literal;
        return new Or((Expression)matchedExpression, (Expression)notMatchedBySourceExpression);
    }

    public static /* synthetic */ Expression generateFilterForNewRows$(ClassicMergeExecutor $this) {
        return $this.generateFilterForNewRows();
    }

    default public Expression generateFilterForNewRows() {
        if (((MergeIntoCommandBase)((Object)this)).notMatchedClauses().nonEmpty()) {
            Expression combinedClauses = this.clauseDisjunction(((MergeIntoCommandBase)((Object)this)).notMatchedClauses());
            return new And(functions$.MODULE$.col(MergeIntoCommandBase$.MODULE$.TARGET_ROW_PRESENT_COL()).isNull().expr(), combinedClauses);
        }
        return Literal$.MODULE$.FalseLiteral();
    }

    public static /* synthetic */ Seq writeAllChanges$(ClassicMergeExecutor $this, SparkSession spark, OptimisticTransaction deltaTxn, Seq filesToRewrite, DeduplicateCDFDeletes deduplicateCDFDeletes, boolean writeUnmodifiedRows) {
        return $this.writeAllChanges(spark, deltaTxn, (Seq<AddFile>)filesToRewrite, deduplicateCDFDeletes, writeUnmodifiedRows);
    }

    default public Seq<FileAction> writeAllChanges(SparkSession spark, OptimisticTransaction deltaTxn, Seq<AddFile> filesToRewrite, DeduplicateCDFDeletes deduplicateCDFDeletes, boolean writeUnmodifiedRows) {
        return (Seq)((MergeIntoCommandBase)((Object)this)).recordMergeOperation(!writeUnmodifiedRows ? "writeModifiedRowsOnly" : (((MergeIntoCommandBase)((Object)this)).shouldOptimizeMatchedOnlyMerge(spark) ? "writeAllUpdatesAndDeletes" : "writeAllChanges"), new StringBuilder(34).append("MERGE operation - Rewriting ").append(filesToRewrite.size()).append(" files").toString(), "rewriteTimeMs", (Function0 & Serializable & scala.Serializable)() -> {
            Seq<FileAction> newFiles;
            block5: {
                Dataset dataset;
                boolean cdcEnabled = ((MergeIntoCommandBase)((Object)this)).isCdcEnabled(deltaTxn);
                Predef$.MODULE$.require(!deduplicateCDFDeletes.enabled() || cdcEnabled, (Function0 & Serializable & scala.Serializable)() -> "CDF delete duplication is enabled but overall the CDF generation is disabled");
                LogicalPlan targetPlan = ((MergeIntoCommandBase)((Object)this)).buildTargetPlanWithFiles(spark, deltaTxn, filesToRewrite, (Seq<String>)Nil$.MODULE$);
                Dataset<Row> baseTargetDF = RowTracking$.MODULE$.preserveRowTrackingColumns((Dataset<Row>)Dataset$.MODULE$.ofRows(spark, targetPlan), deltaTxn.snapshot());
                String joinType = writeUnmodifiedRows ? (((MergeIntoCommandBase)((Object)this)).shouldOptimizeMatchedOnlyMerge(spark) ? "rightOuter" : "fullOuter") : (((MergeIntoCommandBase)((Object)this)).isMatchedOnly() ? "inner" : (((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses().isEmpty() ? "leftOuter" : (((MergeIntoCommandBase)((Object)this)).notMatchedClauses().isEmpty() ? "rightOuter" : "fullOuter")));
                ((Logging)this).logDebug((Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(139).append("writeAllChanges using ").append(joinType).append(" join:\n       |  source.output: ").append(((MergeIntoCommandBase)((Object)this)).source().outputSet()).append("\n       |  target.output: ").append(((MergeIntoCommandBase)((Object)this)).target().outputSet()).append("\n       |  condition: ").append(((MergeIntoCommandBase)((Object)this)).condition()).append("\n       |  newTarget.output: ").append(baseTargetDF.queryExecution().logical().outputSet()).append("\n       ").toString())).stripMargin());
                Expression incrSourceRowCountExpr = ((MergeIntoCommandBase)((Object)this)).incrementMetricAndReturnBool("numSourceRowsInSecondScan", true);
                Expression incrNoopCountExpr = ((MergeIntoCommandBase)((Object)this)).incrementMetricAndReturnBool("numTargetRowsCopied", false);
                Dataset sourceDF = ((MergeIntoMaterializeSource)((Object)this)).getMergeSource().df();
                if (deduplicateCDFDeletes.enabled() && deduplicateCDFDeletes.includesInserts()) {
                    sourceDF = sourceDF.withColumn("_source_row_index", functions$.MODULE$.monotonically_increasing_id());
                }
                Dataset left = sourceDF.withColumn(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL(), Column$.MODULE$.apply(incrSourceRowCountExpr)).filter(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL());
                Dataset targetDF = baseTargetDF.withColumn(MergeIntoCommandBase$.MODULE$.TARGET_ROW_PRESENT_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true)));
                Dataset right = deduplicateCDFDeletes.enabled() ? targetDF.withColumn("_target_row_index_", functions$.MODULE$.monotonically_increasing_id()) : targetDF;
                Dataset joinedBaseDF = left.join(right, Column$.MODULE$.apply(((MergeIntoCommandBase)((Object)this)).condition()), joinType);
                if (writeUnmodifiedRows) {
                    dataset = joinedBaseDF;
                } else {
                    Or filter = new Or(this.generateFilterForModifiedRows(), this.generateFilterForNewRows());
                    dataset = joinedBaseDF.filter(Column$.MODULE$.apply((Expression)filter));
                }
                Dataset joinedDF = dataset;
                Tuple2<Dataset<Row>, Seq<DeltaMergeIntoClause>> tuple2 = this.generatePrecomputedConditionsAndDF((Dataset<Row>)joinedDF, (Seq<DeltaMergeIntoClause>)((Seq)((TraversableLike)((MergeIntoCommandBase)((Object)this)).matchedClauses().$plus$plus(((MergeIntoCommandBase)((Object)this)).notMatchedClauses(), Seq$.MODULE$.canBuildFrom())).$plus$plus(((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses(), Seq$.MODULE$.canBuildFrom())));
                if (tuple2 == null) {
                    throw new MatchError(tuple2);
                }
                Dataset joinedAndPrecomputedConditionsDF = (Dataset)tuple2._1();
                Seq clausesWithPrecompConditions = (Seq)tuple2._2();
                Tuple2 tuple22 = new Tuple2((Object)joinedAndPrecomputedConditionsDF, (Object)clausesWithPrecompConditions);
                Dataset joinedAndPrecomputedConditionsDF2 = (Dataset)tuple22._1();
                Seq clausesWithPrecompConditions2 = (Seq)tuple22._2();
                Option<Attribute> rowIdColumnExpressionOpt = MaterializedRowId$.MODULE$.getAttribute(deltaTxn.snapshot(), (Dataset<Row>)joinedAndPrecomputedConditionsDF2);
                Option<Attribute> rowCommitVersionColumnExpressionOpt = MaterializedRowCommitVersion$.MODULE$.getAttribute(deltaTxn.snapshot(), (Dataset<Row>)joinedAndPrecomputedConditionsDF2);
                Seq<NamedExpression> targetWriteCols = ((MergeIntoCommandBase)((Object)this)).postEvolutionTargetExpressions(true);
                Seq outputColNames = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)((TraversableLike)targetWriteCols.map((Function1 & Serializable & scala.Serializable)x$12 -> x$12.name(), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(rowIdColumnExpressionOpt.map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.name())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(rowCommitVersionColumnExpressionOpt.map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.name())), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)MergeIntoCommandBase$.MODULE$.ROW_DROPPED_COL(), (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(cdcEnabled ? Option$.MODULE$.option2Iterable((Option)new Some((Object)CDCReader$.MODULE$.CDC_TYPE_COLUMN_NAME())) : Option$.MODULE$.option2Iterable((Option)None$.MODULE$)), Seq$.MODULE$.canBuildFrom());
                Seq noopCopyExprs = (Seq)((TraversableLike)((TraversableLike)((TraversableLike)targetWriteCols.$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(rowIdColumnExpressionOpt), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable(rowCommitVersionColumnExpressionOpt), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)new .colon.colon((Object)incrNoopCountExpr, (List)Nil$.MODULE$), Seq$.MODULE$.canBuildFrom())).$plus$plus((GenTraversableOnce)(cdcEnabled ? new .colon.colon((Object)CDCReader$.MODULE$.CDC_TYPE_NOT_CDC(), (List)Nil$.MODULE$) : Nil$.MODULE$), Seq$.MODULE$.canBuildFrom());
                IndexedSeq<Column> outputCols = this.generateWriteAllChangesOutputCols(targetWriteCols, rowIdColumnExpressionOpt, rowCommitVersionColumnExpressionOpt, (Seq<String>)outputColNames, (Seq<Expression>)noopCopyExprs, (Seq<DeltaMergeIntoClause>)clausesWithPrecompConditions2, cdcEnabled, this.generateWriteAllChangesOutputCols$default$8());
                Dataset<Row> preOutputDF = cdcEnabled ? this.generateCdcAndOutputRows((Dataset<Row>)joinedAndPrecomputedConditionsDF2, (Seq<Column>)outputCols, (Seq<String>)outputColNames, (Seq<Expression>)noopCopyExprs, (Option<String>)rowIdColumnExpressionOpt.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.name()), (Option<String>)rowCommitVersionColumnExpressionOpt.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.name()), deduplicateCDFDeletes) : joinedAndPrecomputedConditionsDF2.select(outputCols);
                Dataset outputDF = preOutputDF.filter(new StringBuilder(8).append(MergeIntoCommandBase$.MODULE$.ROW_DROPPED_COL()).append(" = false").toString()).drop(MergeIntoCommandBase$.MODULE$.ROW_DROPPED_COL());
                ((Logging)this).logDebug((Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("writeAllChanges: join output plan:\n").append(outputDF.queryExecution()).toString());
                newFiles = ((MergeIntoCommandBase)((Object)this)).writeFiles(spark, deltaTxn, (Dataset<Row>)outputDF);
                Tuple2<Object, Object> tuple23 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues(newFiles);
                if (tuple23 == null) {
                    throw new MatchError(tuple23);
                }
                long addedBytes = tuple23._1$mcJ$sp();
                int addedPartitions = tuple23._2$mcI$sp();
                Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(addedBytes, addedPartitions);
                long addedBytes2 = sp2._1$mcJ$sp();
                int addedPartitions2 = sp2._2$mcI$sp();
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetFilesAdded")).$plus$eq((long)newFiles.count((Function1 & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToBoolean((boolean)ClassicMergeExecutor.$anonfun$writeAllChanges$10(x$18))));
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetChangeFilesAdded")).$plus$eq((long)newFiles.count((Function1 & Serializable & scala.Serializable)x$19 -> BoxesRunTime.boxToBoolean((boolean)ClassicMergeExecutor.$anonfun$writeAllChanges$11(x$19))));
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetChangeFileBytes")).$plus$eq(BoxesRunTime.unboxToLong((Object)((TraversableOnce)newFiles.collect((PartialFunction)new scala.Serializable(null){
                    public static final long serialVersionUID = 0L;

                    public final <A1 extends FileAction, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        if (A1 instanceof AddCDCFile) {
                            AddCDCFile addCDCFile = (AddCDCFile)A1;
                            return (B1)BoxesRunTime.boxToLong((long)addCDCFile.size());
                        }
                        return (B1)function1.apply(x1);
                    }

                    public final boolean isDefinedAt(FileAction x1) {
                        FileAction fileAction = x1;
                        return fileAction instanceof AddCDCFile;
                    }
                }, Seq$.MODULE$.canBuildFrom())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$)));
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetBytesAdded")).$plus$eq(addedBytes2);
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetPartitionsAddedTo")).$plus$eq((long)addedPartitions2);
                if (!((MergeIntoCommandBase)((Object)this)).multipleMatchDeleteOnlyOvercount().isDefined()) break block5;
                long actualRowsDeleted = ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetRowsDeleted")).value() - BoxesRunTime.unboxToLong((Object)((MergeIntoCommandBase)((Object)this)).multipleMatchDeleteOnlyOvercount().get());
                Predef$.MODULE$.assert(actualRowsDeleted >= 0L);
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetRowsDeleted")).set(actualRowsDeleted);
                long actualRowsMatchedDeleted = ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetRowsMatchedDeleted")).value() - BoxesRunTime.unboxToLong((Object)((MergeIntoCommandBase)((Object)this)).multipleMatchDeleteOnlyOvercount().get());
                Predef$.MODULE$.assert(actualRowsMatchedDeleted >= 0L);
                ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetRowsMatchedDeleted")).set(actualRowsMatchedDeleted);
            }
            return newFiles;
        });
    }

    public static /* synthetic */ Seq writeDVs$(ClassicMergeExecutor $this, SparkSession spark, OptimisticTransaction deltaTxn, Seq filesToRewrite) {
        return $this.writeDVs(spark, deltaTxn, (Seq<AddFile>)filesToRewrite);
    }

    default public Seq<FileAction> writeDVs(SparkSession spark, OptimisticTransaction deltaTxn, Seq<AddFile> filesToRewrite) {
        return (Seq)((MergeIntoCommandBase)((Object)this)).recordMergeOperation("writeDeletionVectors", new StringBuilder(54).append("MERGE operation - Rewriting Deletion Vectors to ").append(filesToRewrite.size()).append(" files").toString(), "rewriteTimeMs", (Function0 & Serializable & scala.Serializable)() -> {
            TahoeBatchFileIndex fileIndex = new TahoeBatchFileIndex(spark, "merge", filesToRewrite, deltaTxn.deltaLog(), deltaTxn.deltaLog().dataPath(), deltaTxn.snapshot(), TahoeBatchFileIndex$.MODULE$.$lessinit$greater$default$7());
            Dataset<Row> targetDF = DMLWithDeletionVectorsHelper$.MODULE$.createTargetDfForScanningForMatches(spark, ((MergeIntoCommandBase)((Object)this)).target(), fileIndex);
            String joinType = ((MergeIntoCommandBase)((Object)this)).notMatchedBySourceClauses().isEmpty() ? "inner" : "rightOuter";
            Dataset joinedDF = ((MergeIntoMaterializeSource)((Object)this)).getMergeSource().df().withColumn(MergeIntoCommandBase$.MODULE$.SOURCE_ROW_PRESENT_COL(), functions$.MODULE$.lit((Object)BoxesRunTime.boxToBoolean((boolean)true))).join(targetDF, Column$.MODULE$.apply(((MergeIntoCommandBase)((Object)this)).condition()), joinType);
            Expression modifiedRowsFilter = this.generateFilterForModifiedRows();
            Seq<DeletionVectorResult> matchedDVResult = DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition(spark, deltaTxn, true, (Dataset<Row>)joinedDF, filesToRewrite, modifiedRowsFilter, DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition$default$7(), DeletionVectorBitmapGenerator$.MODULE$.buildRowIndexSetsForFilesMatchingCondition$default$8());
            Map<String, AddFile> nameToAddFileMap = ((DeltaCommand)((Object)this)).generateCandidateFileMap(((MergeIntoCommandBase)((Object)this)).targetDeltaLog().dataPath(), filesToRewrite);
            Seq<TouchedFileWithDV> touchedFilesWithDVs = DMLWithDeletionVectorsHelper$.MODULE$.findFilesWithMatchingRows(deltaTxn, nameToAddFileMap, matchedDVResult);
            Tuple2<Seq<FileAction>, Map<String, Object>> tuple2 = DMLWithDeletionVectorsHelper$.MODULE$.processUnmodifiedData(spark, touchedFilesWithDVs, deltaTxn.snapshot());
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            Seq dvActions = (Seq)tuple2._1();
            Map metricsMap = (Map)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)dvActions, (Object)metricsMap);
            Seq dvActions2 = (Seq)tuple22._1();
            Map metricsMap2 = (Map)tuple22._2();
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetDeletionVectorsAdded")).set(BoxesRunTime.unboxToLong((Object)metricsMap2.getOrElse((Object)"numDeletionVectorsAdded", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetDeletionVectorsRemoved")).set(BoxesRunTime.unboxToLong((Object)metricsMap2.getOrElse((Object)"numDeletionVectorsRemoved", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetDeletionVectorsUpdated")).set(BoxesRunTime.unboxToLong((Object)metricsMap2.getOrElse((Object)"numDeletionVectorsUpdated", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetFilesRemoved")).set(BoxesRunTime.unboxToLong((Object)metricsMap2.getOrElse((Object)"numRemovedFiles", (Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)));
            Seq fullyRemovedFiles = (Seq)((TraversableLike)touchedFilesWithDVs.filter((Function1 & Serializable & scala.Serializable)x$21 -> BoxesRunTime.boxToBoolean((boolean)x$21.isFullyReplaced()))).map((Function1 & Serializable & scala.Serializable)x$22 -> x$22.fileLogEntry(), Seq$.MODULE$.canBuildFrom());
            Tuple2<Object, Object> tuple23 = MergeIntoCommandBase$.MODULE$.totalBytesAndDistinctPartitionValues((Seq<FileAction>)fullyRemovedFiles);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            long removedBytes = tuple23._1$mcJ$sp();
            int removedPartitions = tuple23._2$mcI$sp();
            Tuple2.mcJI.sp sp2 = new Tuple2.mcJI.sp(removedBytes, removedPartitions);
            long removedBytes2 = sp2._1$mcJ$sp();
            int removedPartitions2 = sp2._2$mcI$sp();
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetBytesRemoved")).set(removedBytes2);
            ((SQLMetric)((MergeIntoCommandBase)((Object)this)).metrics().apply((Object)"numTargetPartitionsRemovedFrom")).set((long)removedPartitions2);
            return dvActions2;
        });
    }

    public static /* synthetic */ boolean $anonfun$findTouchedFiles$9(Function2 columnComparator$1, String field$1, String name) {
        return BoxesRunTime.unboxToBoolean((Object)columnComparator$1.apply((Object)name, (Object)field$1));
    }

    public static /* synthetic */ int $anonfun$findTouchedFiles$10(SetAccumulator touchedFilesAccum$1, String fileName, boolean shouldRecord) {
        block0: {
            if (!shouldRecord) break block0;
            touchedFilesAccum$1.add(fileName);
        }
        return 1;
    }

    public static /* synthetic */ boolean $anonfun$findTouchedFiles$13(AddFile x$7) {
        return BoxesRunTime.equals((Object)x$7.numLogicalRecords().getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> 0), (Object)BoxesRunTime.boxToInteger((int)0));
    }

    public static /* synthetic */ boolean $anonfun$writeAllChanges$10(FileAction x$18) {
        return x$18 instanceof AddFile;
    }

    public static /* synthetic */ boolean $anonfun$writeAllChanges$11(FileAction x$19) {
        return x$19 instanceof AddCDCFile;
    }

    public static void $init$(ClassicMergeExecutor $this) {
    }
}

