/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.converters;

import com.amazonaws.glue.catalog.converters.ConverterUtils;
import com.amazonaws.services.glue.model.BinaryColumnStatisticsData;
import com.amazonaws.services.glue.model.BooleanColumnStatisticsData;
import com.amazonaws.services.glue.model.Column;
import com.amazonaws.services.glue.model.ColumnStatistics;
import com.amazonaws.services.glue.model.ColumnStatisticsType;
import com.amazonaws.services.glue.model.Database;
import com.amazonaws.services.glue.model.DateColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalColumnStatisticsData;
import com.amazonaws.services.glue.model.DecimalNumber;
import com.amazonaws.services.glue.model.DoubleColumnStatisticsData;
import com.amazonaws.services.glue.model.LongColumnStatisticsData;
import com.amazonaws.services.glue.model.Order;
import com.amazonaws.services.glue.model.Partition;
import com.amazonaws.services.glue.model.ResourceUri;
import com.amazonaws.services.glue.model.SerDeInfo;
import com.amazonaws.services.glue.model.StorageDescriptor;
import com.amazonaws.services.glue.model.StringColumnStatisticsData;
import com.amazonaws.services.glue.model.UserDefinedFunction;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.hive.metastore.api.BinaryColumnStatsData;
import org.apache.hadoop.hive.metastore.api.BooleanColumnStatsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsData;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsDesc;
import org.apache.hadoop.hive.metastore.api.ColumnStatisticsObj;
import org.apache.hadoop.hive.metastore.api.DateColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Decimal;
import org.apache.hadoop.hive.metastore.api.DecimalColumnStatsData;
import org.apache.hadoop.hive.metastore.api.DoubleColumnStatsData;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Function;
import org.apache.hadoop.hive.metastore.api.LongColumnStatsData;
import org.apache.hadoop.hive.metastore.api.SkewedInfo;
import org.apache.hadoop.hive.metastore.api.StringColumnStatsData;
import org.apache.hadoop.hive.metastore.api.Table;

public class HiveToCatalogConverter {
    public static Database convertDatabase(org.apache.hadoop.hive.metastore.api.Database hiveDatabase) {
        Database catalogDatabase = new Database();
        catalogDatabase.setName(hiveDatabase.getName());
        catalogDatabase.setDescription(hiveDatabase.getDescription());
        catalogDatabase.setLocationUri(hiveDatabase.getLocationUri());
        catalogDatabase.setParameters(hiveDatabase.getParameters());
        return catalogDatabase;
    }

    public static com.amazonaws.services.glue.model.Table convertTable(Table hiveTable) {
        com.amazonaws.services.glue.model.Table catalogTable = new com.amazonaws.services.glue.model.Table();
        catalogTable.setRetention(Integer.valueOf(hiveTable.getRetention()));
        catalogTable.setPartitionKeys(HiveToCatalogConverter.convertFieldSchemaList(hiveTable.getPartitionKeys()));
        catalogTable.setTableType(hiveTable.getTableType());
        catalogTable.setName(hiveTable.getTableName());
        catalogTable.setOwner(hiveTable.getOwner());
        catalogTable.setCreateTime(new Date((long)hiveTable.getCreateTime() * 1000L));
        catalogTable.setLastAccessTime(new Date((long)hiveTable.getLastAccessTime() * 1000L));
        catalogTable.setStorageDescriptor(HiveToCatalogConverter.convertStorageDescriptor(hiveTable.getSd()));
        catalogTable.setParameters(hiveTable.getParameters());
        catalogTable.setViewExpandedText(hiveTable.getViewExpandedText());
        catalogTable.setViewOriginalText(hiveTable.getViewOriginalText());
        return catalogTable;
    }

    public static StorageDescriptor convertStorageDescriptor(org.apache.hadoop.hive.metastore.api.StorageDescriptor hiveSd) {
        StorageDescriptor catalogSd = new StorageDescriptor();
        catalogSd.setNumberOfBuckets(Integer.valueOf(hiveSd.getNumBuckets()));
        catalogSd.setCompressed(Boolean.valueOf(hiveSd.isCompressed()));
        catalogSd.setParameters(hiveSd.getParameters());
        catalogSd.setBucketColumns((Collection)hiveSd.getBucketCols());
        catalogSd.setColumns(HiveToCatalogConverter.convertFieldSchemaList(hiveSd.getCols()));
        catalogSd.setInputFormat(hiveSd.getInputFormat());
        catalogSd.setLocation(hiveSd.getLocation());
        catalogSd.setOutputFormat(hiveSd.getOutputFormat());
        catalogSd.setSerdeInfo(HiveToCatalogConverter.convertSerDeInfo(hiveSd.getSerdeInfo()));
        catalogSd.setSkewedInfo(HiveToCatalogConverter.convertSkewedInfo(hiveSd.getSkewedInfo()));
        catalogSd.setSortColumns(HiveToCatalogConverter.convertOrderList(hiveSd.getSortCols()));
        catalogSd.setStoredAsSubDirectories(Boolean.valueOf(hiveSd.isStoredAsSubDirectories()));
        return catalogSd;
    }

    public static Column convertFieldSchema(FieldSchema hiveFieldSchema) {
        Column catalogFieldSchema = new Column();
        catalogFieldSchema.setComment(hiveFieldSchema.getComment());
        catalogFieldSchema.setName(hiveFieldSchema.getName());
        catalogFieldSchema.setType(hiveFieldSchema.getType());
        return catalogFieldSchema;
    }

    public static List<Column> convertFieldSchemaList(List<FieldSchema> hiveFieldSchemaList) {
        ArrayList<Column> catalogFieldSchemaList = new ArrayList<Column>();
        for (FieldSchema hiveFs : hiveFieldSchemaList) {
            catalogFieldSchemaList.add(HiveToCatalogConverter.convertFieldSchema(hiveFs));
        }
        return catalogFieldSchemaList;
    }

    public static SerDeInfo convertSerDeInfo(org.apache.hadoop.hive.metastore.api.SerDeInfo hiveSerDeInfo) {
        SerDeInfo catalogSerDeInfo = new SerDeInfo();
        catalogSerDeInfo.setName(hiveSerDeInfo.getName());
        catalogSerDeInfo.setParameters(hiveSerDeInfo.getParameters());
        catalogSerDeInfo.setSerializationLibrary(hiveSerDeInfo.getSerializationLib());
        return catalogSerDeInfo;
    }

    public static com.amazonaws.services.glue.model.SkewedInfo convertSkewedInfo(SkewedInfo hiveSkewedInfo) {
        if (hiveSkewedInfo == null) {
            return null;
        }
        com.amazonaws.services.glue.model.SkewedInfo catalogSkewedInfo = new com.amazonaws.services.glue.model.SkewedInfo().withSkewedColumnNames((Collection)hiveSkewedInfo.getSkewedColNames()).withSkewedColumnValues(HiveToCatalogConverter.convertSkewedValue(hiveSkewedInfo.getSkewedColValues())).withSkewedColumnValueLocationMaps(HiveToCatalogConverter.convertSkewedMap(hiveSkewedInfo.getSkewedColValueLocationMaps()));
        return catalogSkewedInfo;
    }

    public static Order convertOrder(org.apache.hadoop.hive.metastore.api.Order hiveOrder) {
        Order order = new Order();
        order.setColumn(hiveOrder.getCol());
        order.setSortOrder(Integer.valueOf(hiveOrder.getOrder()));
        return order;
    }

    public static List<Order> convertOrderList(List<org.apache.hadoop.hive.metastore.api.Order> hiveOrderList) {
        if (hiveOrderList == null) {
            return null;
        }
        ArrayList<Order> catalogOrderList = new ArrayList<Order>();
        for (org.apache.hadoop.hive.metastore.api.Order hiveOrder : hiveOrderList) {
            catalogOrderList.add(HiveToCatalogConverter.convertOrder(hiveOrder));
        }
        return catalogOrderList;
    }

    public static Partition convertPartition(org.apache.hadoop.hive.metastore.api.Partition src) {
        Partition tgt = new Partition();
        tgt.setDatabaseName(src.getDbName());
        tgt.setTableName(src.getTableName());
        tgt.setCreationTime(new Date((long)src.getCreateTime() * 1000L));
        tgt.setLastAccessTime(new Date((long)src.getLastAccessTime() * 1000L));
        tgt.setParameters(src.getParameters());
        tgt.setStorageDescriptor(HiveToCatalogConverter.convertStorageDescriptor(src.getSd()));
        tgt.setValues((Collection)src.getValues());
        return tgt;
    }

    public static String convertListToString(List<String> list) {
        if (list == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < list.size(); ++i) {
            String currentString = list.get(i);
            sb.append(currentString.length() + "$" + currentString);
        }
        return sb.toString();
    }

    public static Map<String, String> convertSkewedMap(Map<List<String>, String> coreSkewedMap) {
        if (coreSkewedMap == null) {
            return null;
        }
        HashMap<String, String> catalogSkewedMap = new HashMap<String, String>();
        for (List<String> coreKey : coreSkewedMap.keySet()) {
            catalogSkewedMap.put(HiveToCatalogConverter.convertListToString(coreKey), coreSkewedMap.get(coreKey));
        }
        return catalogSkewedMap;
    }

    public static List<String> convertSkewedValue(List<List<String>> coreSkewedValue) {
        if (coreSkewedValue == null) {
            return null;
        }
        ArrayList<String> catalogSkewedValue = new ArrayList<String>();
        for (int i = 0; i < coreSkewedValue.size(); ++i) {
            catalogSkewedValue.add(HiveToCatalogConverter.convertListToString(coreSkewedValue.get(i)));
        }
        return catalogSkewedValue;
    }

    public static UserDefinedFunction convertFunction(Function hiveFunction) {
        if (hiveFunction == null) {
            return null;
        }
        UserDefinedFunction catalogFunction = new UserDefinedFunction();
        catalogFunction.setClassName(hiveFunction.getClassName());
        catalogFunction.setFunctionName(hiveFunction.getFunctionName());
        catalogFunction.setCreateTime(new Date((long)hiveFunction.getCreateTime() * 1000L));
        catalogFunction.setOwnerName(hiveFunction.getOwnerName());
        if (hiveFunction.getOwnerType() != null) {
            catalogFunction.setOwnerType(hiveFunction.getOwnerType().name());
        }
        catalogFunction.setResourceUris(HiveToCatalogConverter.covertResourceUriList(hiveFunction.getResourceUris()));
        return catalogFunction;
    }

    public static List<ResourceUri> covertResourceUriList(List<org.apache.hadoop.hive.metastore.api.ResourceUri> hiveResourceUriList) {
        if (hiveResourceUriList == null) {
            return null;
        }
        ArrayList<ResourceUri> catalogResourceUriList = new ArrayList<ResourceUri>();
        for (org.apache.hadoop.hive.metastore.api.ResourceUri hiveResourceUri : hiveResourceUriList) {
            ResourceUri catalogResourceUri = new ResourceUri();
            catalogResourceUri.setUri(hiveResourceUri.getUri());
            if (hiveResourceUri.getResourceType() != null) {
                catalogResourceUri.setResourceType(hiveResourceUri.getResourceType().name());
            }
            catalogResourceUriList.add(catalogResourceUri);
        }
        return catalogResourceUriList;
    }

    public static List<ColumnStatistics> convertColumnStatisticsObjList(org.apache.hadoop.hive.metastore.api.ColumnStatistics hiveColumnStatistics) {
        ColumnStatisticsDesc hiveColumnStatisticsDesc = hiveColumnStatistics.getStatsDesc();
        List hiveColumnStatisticsObjs = hiveColumnStatistics.getStatsObj();
        ArrayList<ColumnStatistics> catalogColumnStatisticsList = new ArrayList<ColumnStatistics>();
        for (ColumnStatisticsObj hiveColumnStatisticsObj : hiveColumnStatisticsObjs) {
            ColumnStatistics catalogColumnStatistics = new ColumnStatistics();
            catalogColumnStatistics.setColumnName(hiveColumnStatisticsObj.getColName());
            catalogColumnStatistics.setColumnType(hiveColumnStatisticsObj.getColType());
            catalogColumnStatistics.setAnalyzedTime(new Date(TimeUnit.DAYS.toMillis(hiveColumnStatisticsDesc.getLastAnalyzed())));
            catalogColumnStatistics.setStatisticsData(HiveToCatalogConverter.convertColumnStatisticsData(hiveColumnStatisticsObj.getStatsData()));
            catalogColumnStatisticsList.add(catalogColumnStatistics);
        }
        return catalogColumnStatisticsList;
    }

    private static com.amazonaws.services.glue.model.ColumnStatisticsData convertColumnStatisticsData(ColumnStatisticsData hiveColumnStatisticsData) {
        com.amazonaws.services.glue.model.ColumnStatisticsData catalogColumnStatisticsData = new com.amazonaws.services.glue.model.ColumnStatisticsData();
        ColumnStatisticsData._Fields setField = (ColumnStatisticsData._Fields)hiveColumnStatisticsData.getSetField();
        switch (setField) {
            case BINARY_STATS: {
                BinaryColumnStatsData hiveBinaryData = hiveColumnStatisticsData.getBinaryStats();
                BinaryColumnStatisticsData catalogBinaryData = new BinaryColumnStatisticsData();
                catalogBinaryData.setNumberOfNulls(Long.valueOf(hiveBinaryData.getNumNulls()));
                catalogBinaryData.setMaximumLength(Long.valueOf(hiveBinaryData.getMaxColLen()));
                catalogBinaryData.setAverageLength(Double.valueOf(hiveBinaryData.getAvgColLen()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.BINARY));
                catalogColumnStatisticsData.setBinaryColumnStatisticsData(catalogBinaryData);
                break;
            }
            case BOOLEAN_STATS: {
                BooleanColumnStatsData hiveBooleanData = hiveColumnStatisticsData.getBooleanStats();
                BooleanColumnStatisticsData catalogBooleanData = new BooleanColumnStatisticsData();
                catalogBooleanData.setNumberOfNulls(Long.valueOf(hiveBooleanData.getNumNulls()));
                catalogBooleanData.setNumberOfFalses(Long.valueOf(hiveBooleanData.getNumFalses()));
                catalogBooleanData.setNumberOfTrues(Long.valueOf(hiveBooleanData.getNumTrues()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.BOOLEAN));
                catalogColumnStatisticsData.setBooleanColumnStatisticsData(catalogBooleanData);
                break;
            }
            case DATE_STATS: {
                DateColumnStatsData hiveDateData = hiveColumnStatisticsData.getDateStats();
                DateColumnStatisticsData catalogDateData = new DateColumnStatisticsData();
                catalogDateData.setNumberOfNulls(Long.valueOf(hiveDateData.getNumNulls()));
                catalogDateData.setNumberOfDistinctValues(Long.valueOf(hiveDateData.getNumDVs()));
                catalogDateData.setMaximumValue(ConverterUtils.hiveDatetoDate(hiveDateData.getHighValue()));
                catalogDateData.setMinimumValue(ConverterUtils.hiveDatetoDate(hiveDateData.getLowValue()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.DATE));
                catalogColumnStatisticsData.setDateColumnStatisticsData(catalogDateData);
                break;
            }
            case DECIMAL_STATS: {
                DecimalColumnStatsData hiveDecimalData = hiveColumnStatisticsData.getDecimalStats();
                DecimalColumnStatisticsData catalogDecimalData = new DecimalColumnStatisticsData();
                catalogDecimalData.setNumberOfNulls(Long.valueOf(hiveDecimalData.getNumNulls()));
                catalogDecimalData.setNumberOfDistinctValues(Long.valueOf(hiveDecimalData.getNumDVs()));
                catalogDecimalData.setMaximumValue(HiveToCatalogConverter.convertDecimal(hiveDecimalData.getHighValue()));
                catalogDecimalData.setMinimumValue(HiveToCatalogConverter.convertDecimal(hiveDecimalData.getLowValue()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.DECIMAL));
                catalogColumnStatisticsData.setDecimalColumnStatisticsData(catalogDecimalData);
                break;
            }
            case DOUBLE_STATS: {
                DoubleColumnStatsData hiveDoubleData = hiveColumnStatisticsData.getDoubleStats();
                DoubleColumnStatisticsData catalogDoubleData = new DoubleColumnStatisticsData();
                catalogDoubleData.setNumberOfNulls(Long.valueOf(hiveDoubleData.getNumNulls()));
                catalogDoubleData.setNumberOfDistinctValues(Long.valueOf(hiveDoubleData.getNumDVs()));
                catalogDoubleData.setMaximumValue(Double.valueOf(hiveDoubleData.getHighValue()));
                catalogDoubleData.setMinimumValue(Double.valueOf(hiveDoubleData.getLowValue()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.DOUBLE));
                catalogColumnStatisticsData.setDoubleColumnStatisticsData(catalogDoubleData);
                break;
            }
            case LONG_STATS: {
                LongColumnStatsData hiveLongData = hiveColumnStatisticsData.getLongStats();
                LongColumnStatisticsData catalogLongData = new LongColumnStatisticsData();
                catalogLongData.setNumberOfNulls(Long.valueOf(hiveLongData.getNumNulls()));
                catalogLongData.setNumberOfDistinctValues(Long.valueOf(hiveLongData.getNumDVs()));
                catalogLongData.setMaximumValue(Long.valueOf(hiveLongData.getHighValue()));
                catalogLongData.setMinimumValue(Long.valueOf(hiveLongData.getLowValue()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.LONG));
                catalogColumnStatisticsData.setLongColumnStatisticsData(catalogLongData);
                break;
            }
            case STRING_STATS: {
                StringColumnStatsData hiveStringData = hiveColumnStatisticsData.getStringStats();
                StringColumnStatisticsData catalogStringData = new StringColumnStatisticsData();
                catalogStringData.setNumberOfNulls(Long.valueOf(hiveStringData.getNumNulls()));
                catalogStringData.setNumberOfDistinctValues(Long.valueOf(hiveStringData.getNumDVs()));
                catalogStringData.setMaximumLength(Long.valueOf(hiveStringData.getMaxColLen()));
                catalogStringData.setAverageLength(Double.valueOf(hiveStringData.getAvgColLen()));
                catalogColumnStatisticsData.setType(String.valueOf(ColumnStatisticsType.STRING));
                catalogColumnStatisticsData.setStringColumnStatisticsData(catalogStringData);
            }
        }
        return catalogColumnStatisticsData;
    }

    private static DecimalNumber convertDecimal(Decimal hiveDecimal) {
        DecimalNumber catalogDecimal = new DecimalNumber();
        catalogDecimal.setUnscaledValue(ByteBuffer.wrap(hiveDecimal.getUnscaled()));
        catalogDecimal.setScale(Integer.valueOf(hiveDecimal.getScale()));
        return catalogDecimal;
    }
}

