/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.catalog.converters;

import com.amazonaws.glue.catalog.exceptions.InvalidPartitionNameException;
import com.google.common.collect.ImmutableSet;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PartitionNameParser {
    private static final Pattern PARTITION_NAME_VALUE_PATTERN = Pattern.compile("([^/]+)=([^/]+)");
    private static final String PARTITION_NAME_DELIMITER = "/";
    private static final char STORE_AS_NUMBER = 'n';
    private static final char STORE_AS_STRING = 's';
    private static final Set<String> NUMERIC_PARTITION_COLUMN_TYPES = ImmutableSet.of((Object)"tinyint", (Object)"smallint", (Object)"int", (Object)"bigint");

    public static String getPartitionName(List<String> partitionColumns, List<String> partitionValues) {
        if (PartitionNameParser.hasInvalidValues(partitionColumns, partitionValues) || PartitionNameParser.hasInvalidSize(partitionColumns, partitionValues)) {
            throw new IllegalArgumentException("Partition is not well formed. Columns and values do no match.");
        }
        StringBuilder partitionName = new StringBuilder();
        partitionName.append(PartitionNameParser.getPartitionColumnName(partitionColumns.get(0), partitionValues.get(0)));
        for (int i = 1; i < partitionColumns.size(); ++i) {
            partitionName.append(PARTITION_NAME_DELIMITER);
            partitionName.append(PartitionNameParser.getPartitionColumnName(partitionColumns.get(i), partitionValues.get(i)));
        }
        return partitionName.toString();
    }

    private static boolean hasInvalidValues(List<String> partitionColumns, List<String> partitionValues) {
        return partitionColumns == null || partitionValues == null;
    }

    private static boolean hasInvalidSize(List<String> partitionColumns, List<String> partitionValues) {
        return partitionColumns.size() != partitionValues.size();
    }

    private static String getPartitionColumnName(String partitionColumn, String partitionValue) {
        return partitionColumn + "=" + partitionValue;
    }

    public static LinkedHashMap<String, String> getPartitionColumns(String partitionName) {
        String[] partitions;
        LinkedHashMap<String, String> partitionColumns = new LinkedHashMap<String, String>();
        for (String partition : partitions = partitionName.split(PARTITION_NAME_DELIMITER)) {
            AbstractMap.SimpleEntry entry = PartitionNameParser.getPartitionColumnValuePair(partition);
            partitionColumns.put((String)entry.getKey(), (String)entry.getValue());
        }
        return partitionColumns;
    }

    public static String unescapePathName(String path) {
        int len = path.length();
        StringBuilder sb = new StringBuilder(len);
        for (int i = 0; i < len; ++i) {
            char c = path.charAt(i);
            if (c == '%' && i + 2 < len) {
                int code = -1;
                try {
                    code = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                }
                catch (Exception e) {
                    code = -1;
                }
                if (code >= 0) {
                    sb.append((char)code);
                    i += 2;
                    continue;
                }
            }
            sb.append(c);
        }
        return sb.toString();
    }

    private static AbstractMap.SimpleEntry getPartitionColumnValuePair(String partition) {
        String column = null;
        String value = null;
        Matcher partitionMatcher = PARTITION_NAME_VALUE_PATTERN.matcher(partition);
        if (!partitionMatcher.matches()) {
            throw new InvalidPartitionNameException(partition);
        }
        column = PartitionNameParser.unescapePathName(partitionMatcher.group(1));
        value = PartitionNameParser.unescapePathName(partitionMatcher.group(2));
        return new AbstractMap.SimpleEntry<String, String>(column, value);
    }

    public static List<String> getPartitionValuesFromName(String partitionName) {
        String[] partitions;
        ArrayList<String> partitionValues = new ArrayList<String>();
        for (String partition : partitions = partitionName.split(PARTITION_NAME_DELIMITER)) {
            AbstractMap.SimpleEntry entry = PartitionNameParser.getPartitionColumnValuePair(partition);
            partitionValues.add((String)entry.getValue());
        }
        return partitionValues;
    }
}

