/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.glue.shims;

import com.amazonaws.glue.shims.AwsGlueHive3Shims;
import com.amazonaws.glue.shims.AwsGlueHiveShims;
import com.amazonaws.glue.shims.AwsGlueSparkHiveShims;
import com.google.common.annotations.VisibleForTesting;
import org.apache.hive.common.util.HiveVersionInfo;

public final class ShimsLoader {
    private static AwsGlueHiveShims hiveShims;

    public static synchronized AwsGlueHiveShims getHiveShims() {
        if (hiveShims == null) {
            hiveShims = ShimsLoader.loadHiveShims();
        }
        return hiveShims;
    }

    private static AwsGlueHiveShims loadHiveShims() {
        String hiveVersion = HiveVersionInfo.getShortVersion();
        try {
            if (AwsGlueSparkHiveShims.supportsVersion(hiveVersion)) {
                return (AwsGlueHiveShims)AwsGlueSparkHiveShims.class.newInstance();
            }
            if (AwsGlueHive3Shims.supportsVersion(hiveVersion)) {
                return (AwsGlueHiveShims)AwsGlueHive3Shims.class.newInstance();
            }
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new RuntimeException("unable to get instance of Hive shim class for " + hiveVersion);
        }
        throw new RuntimeException("Shim class for Hive version " + hiveVersion + " does not exist");
    }

    @VisibleForTesting
    static synchronized void clearShimClass() {
        hiveShims = null;
    }
}

