/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls;

import com.google.cloud.hadoop.repackaged.gcs.com.google.common.base.Preconditions;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.ConnectivityState;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.LoadBalancer;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.rls.SubchannelStateManager;
import com.google.cloud.hadoop.repackaged.gcs.io.grpc.util.ForwardingLoadBalancerHelper;
import javax.annotation.Nonnull;

final class ChildLoadBalancerHelper
extends ForwardingLoadBalancerHelper {
    private final String target;
    private final LoadBalancer.Helper rlsHelper;
    private final SubchannelStateManager subchannelStateManager;
    private final LoadBalancer.SubchannelPicker picker;

    private ChildLoadBalancerHelper(String target, LoadBalancer.Helper rlsHelper, SubchannelStateManager subchannelStateManager, LoadBalancer.SubchannelPicker picker) {
        this.target = Preconditions.checkNotNull(target, "target");
        this.rlsHelper = Preconditions.checkNotNull(rlsHelper, "rlsHelper");
        this.subchannelStateManager = Preconditions.checkNotNull(subchannelStateManager, "subchannelStateManager");
        this.picker = Preconditions.checkNotNull(picker, "picker");
    }

    @Override
    protected LoadBalancer.Helper delegate() {
        return this.rlsHelper;
    }

    @Override
    public void updateBalancingState(@Nonnull ConnectivityState newState, @Nonnull LoadBalancer.SubchannelPicker unused) {
        this.subchannelStateManager.updateState(this.target, newState);
        super.updateBalancingState(this.subchannelStateManager.getAggregatedState(), this.picker);
    }

    static final class ChildLoadBalancerHelperProvider {
        private final LoadBalancer.Helper helper;
        private final SubchannelStateManager subchannelStateManager;
        private final LoadBalancer.SubchannelPicker picker;

        ChildLoadBalancerHelperProvider(LoadBalancer.Helper helper, SubchannelStateManager subchannelStateManager, LoadBalancer.SubchannelPicker picker) {
            this.helper = Preconditions.checkNotNull(helper, "helper");
            this.subchannelStateManager = Preconditions.checkNotNull(subchannelStateManager, "subchannelStateManager");
            this.picker = Preconditions.checkNotNull(picker, "picker");
        }

        ChildLoadBalancerHelper forTarget(String target) {
            return new ChildLoadBalancerHelper(target, this.helper, this.subchannelStateManager, this.picker);
        }
    }
}

