/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.AuthorizeClientVpnIngressRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class AuthorizeClientVpnIngressRequestMarshaller
implements Marshaller<Request<AuthorizeClientVpnIngressRequest>, AuthorizeClientVpnIngressRequest> {
    @Override
    public Request<AuthorizeClientVpnIngressRequest> marshall(AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) {
        if (authorizeClientVpnIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<AuthorizeClientVpnIngressRequest> request = new DefaultRequest<AuthorizeClientVpnIngressRequest>(authorizeClientVpnIngressRequest, "AmazonEC2");
        request.addParameter("Action", "AuthorizeClientVpnIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeClientVpnIngressRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString(authorizeClientVpnIngressRequest.getClientVpnEndpointId()));
        }
        if (authorizeClientVpnIngressRequest.getTargetNetworkCidr() != null) {
            request.addParameter("TargetNetworkCidr", StringUtils.fromString(authorizeClientVpnIngressRequest.getTargetNetworkCidr()));
        }
        if (authorizeClientVpnIngressRequest.getAccessGroupId() != null) {
            request.addParameter("AccessGroupId", StringUtils.fromString(authorizeClientVpnIngressRequest.getAccessGroupId()));
        }
        if (authorizeClientVpnIngressRequest.getAuthorizeAllGroups() != null) {
            request.addParameter("AuthorizeAllGroups", StringUtils.fromBoolean(authorizeClientVpnIngressRequest.getAuthorizeAllGroups()));
        }
        if (authorizeClientVpnIngressRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(authorizeClientVpnIngressRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(authorizeClientVpnIngressRequest.getClientToken()));
        return request;
    }
}

