/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.transform;

import com.dataiku.dss.legacy.aws.com.amazonaws.DefaultRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.Request;
import com.dataiku.dss.legacy.aws.com.amazonaws.SdkClientException;
import com.dataiku.dss.legacy.aws.com.amazonaws.http.HttpMethodName;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.CreateTrafficMirrorFilterRuleRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.services.ec2.model.TrafficMirrorPortRangeRequest;
import com.dataiku.dss.legacy.aws.com.amazonaws.transform.Marshaller;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.IdempotentUtils;
import com.dataiku.dss.legacy.aws.com.amazonaws.util.StringUtils;

public class CreateTrafficMirrorFilterRuleRequestMarshaller
implements Marshaller<Request<CreateTrafficMirrorFilterRuleRequest>, CreateTrafficMirrorFilterRuleRequest> {
    @Override
    public Request<CreateTrafficMirrorFilterRuleRequest> marshall(CreateTrafficMirrorFilterRuleRequest createTrafficMirrorFilterRuleRequest) {
        TrafficMirrorPortRangeRequest sourcePortRange;
        TrafficMirrorPortRangeRequest destinationPortRange;
        if (createTrafficMirrorFilterRuleRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest<CreateTrafficMirrorFilterRuleRequest> request = new DefaultRequest<CreateTrafficMirrorFilterRuleRequest>(createTrafficMirrorFilterRuleRequest, "AmazonEC2");
        request.addParameter("Action", "CreateTrafficMirrorFilterRule");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createTrafficMirrorFilterRuleRequest.getTrafficMirrorFilterId() != null) {
            request.addParameter("TrafficMirrorFilterId", StringUtils.fromString(createTrafficMirrorFilterRuleRequest.getTrafficMirrorFilterId()));
        }
        if (createTrafficMirrorFilterRuleRequest.getTrafficDirection() != null) {
            request.addParameter("TrafficDirection", StringUtils.fromString(createTrafficMirrorFilterRuleRequest.getTrafficDirection()));
        }
        if (createTrafficMirrorFilterRuleRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger(createTrafficMirrorFilterRuleRequest.getRuleNumber()));
        }
        if (createTrafficMirrorFilterRuleRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString(createTrafficMirrorFilterRuleRequest.getRuleAction()));
        }
        if ((destinationPortRange = createTrafficMirrorFilterRuleRequest.getDestinationPortRange()) != null) {
            if (destinationPortRange.getFromPort() != null) {
                request.addParameter("DestinationPortRange.FromPort", StringUtils.fromInteger(destinationPortRange.getFromPort()));
            }
            if (destinationPortRange.getToPort() != null) {
                request.addParameter("DestinationPortRange.ToPort", StringUtils.fromInteger(destinationPortRange.getToPort()));
            }
        }
        if ((sourcePortRange = createTrafficMirrorFilterRuleRequest.getSourcePortRange()) != null) {
            if (sourcePortRange.getFromPort() != null) {
                request.addParameter("SourcePortRange.FromPort", StringUtils.fromInteger(sourcePortRange.getFromPort()));
            }
            if (sourcePortRange.getToPort() != null) {
                request.addParameter("SourcePortRange.ToPort", StringUtils.fromInteger(sourcePortRange.getToPort()));
            }
        }
        if (createTrafficMirrorFilterRuleRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromInteger(createTrafficMirrorFilterRuleRequest.getProtocol()));
        }
        if (createTrafficMirrorFilterRuleRequest.getDestinationCidrBlock() != null) {
            request.addParameter("DestinationCidrBlock", StringUtils.fromString(createTrafficMirrorFilterRuleRequest.getDestinationCidrBlock()));
        }
        if (createTrafficMirrorFilterRuleRequest.getSourceCidrBlock() != null) {
            request.addParameter("SourceCidrBlock", StringUtils.fromString(createTrafficMirrorFilterRuleRequest.getSourceCidrBlock()));
        }
        if (createTrafficMirrorFilterRuleRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString(createTrafficMirrorFilterRuleRequest.getDescription()));
        }
        request.addParameter("ClientToken", IdempotentUtils.resolveString(createTrafficMirrorFilterRuleRequest.getClientToken()));
        return request;
    }
}

