/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.http;

import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpPipelineNextSyncPolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.http.HttpResponse;
import com.dataiku.dss.shadelibazure.com.azure.core.http.policy.HttpPipelinePolicy;
import com.dataiku.dss.shadelibazure.com.azure.core.implementation.http.HttpPipelineCallState;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.LogLevel;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import com.dataiku.dss.shadelibazure.reactor.core.scheduler.Schedulers;

public class HttpPipelineNextPolicy {
    private static final ClientLogger LOGGER = new ClientLogger(HttpPipelineNextPolicy.class);
    private final HttpPipelineCallState state;
    private final boolean originatedFromSyncPolicy;

    HttpPipelineNextPolicy(HttpPipelineCallState state) {
        this.state = state;
        this.originatedFromSyncPolicy = false;
    }

    HttpPipelineNextPolicy(HttpPipelineCallState state, boolean originatedFromSyncPolicy) {
        this.state = state;
        this.originatedFromSyncPolicy = originatedFromSyncPolicy;
    }

    public Mono<HttpResponse> process() {
        HttpPipelinePolicy nextPolicy;
        if (this.originatedFromSyncPolicy && !Schedulers.isInNonBlockingThread()) {
            return Mono.fromCallable(() -> new HttpPipelineNextSyncPolicy(this.state).processSync());
        }
        if (this.originatedFromSyncPolicy) {
            LOGGER.log(LogLevel.WARNING, () -> "The pipeline switched from synchronous to asynchronous. Check if " + this.state.getCurrentPolicy().getClass().getSimpleName() + " does not override HttpPipelinePolicy.processSync");
        }
        if ((nextPolicy = this.state.getNextPolicy()) == null) {
            return this.state.getPipeline().getHttpClient().send(this.state.getCallContext().getHttpRequest(), this.state.getCallContext().getContext());
        }
        return nextPolicy.process(this.state.getCallContext(), this);
    }

    public HttpPipelineNextPolicy clone() {
        return new HttpPipelineNextPolicy(this.state.clone(), this.originatedFromSyncPolicy);
    }
}

