/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Objects;

public final class GeoBoundingBox
implements JsonSerializable<GeoBoundingBox> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoBoundingBox.class);
    private final double west;
    private final double south;
    private final double east;
    private final double north;
    private final Double minAltitude;
    private final Double maxAltitude;

    public GeoBoundingBox(double west, double south, double east, double north) {
        this(west, south, east, north, null, null, null);
    }

    public GeoBoundingBox(double west, double south, double east, double north, double minAltitude, double maxAltitude) {
        this(west, south, east, north, minAltitude, maxAltitude, null);
    }

    private GeoBoundingBox(double west, double south, double east, double north, Double minAltitude, Double maxAltitude, String ignored) {
        this.west = west;
        this.south = south;
        this.east = east;
        this.north = north;
        this.minAltitude = minAltitude;
        this.maxAltitude = maxAltitude;
    }

    public double getWest() {
        return this.west;
    }

    public double getSouth() {
        return this.south;
    }

    public double getEast() {
        return this.east;
    }

    public double getNorth() {
        return this.north;
    }

    public Double getMinAltitude() {
        return this.minAltitude;
    }

    public Double getMaxAltitude() {
        return this.maxAltitude;
    }

    public int hashCode() {
        return Objects.hash(this.west, this.south, this.east, this.north, this.minAltitude, this.maxAltitude);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoBoundingBox)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoBoundingBox other = (GeoBoundingBox)obj;
        return Double.compare(this.west, other.west) == 0 && Double.compare(this.south, other.south) == 0 && Double.compare(this.east, other.east) == 0 && Double.compare(this.north, other.north) == 0 && Objects.equals(this.minAltitude, other.minAltitude) && Objects.equals(this.maxAltitude, other.maxAltitude);
    }

    double get(int i) {
        if (this.minAltitude != null && this.maxAltitude != null) {
            switch (i) {
                case 0: {
                    return this.west;
                }
                case 1: {
                    return this.south;
                }
                case 2: {
                    return this.minAltitude;
                }
                case 3: {
                    return this.east;
                }
                case 4: {
                    return this.north;
                }
                case 5: {
                    return this.maxAltitude;
                }
            }
            throw LOGGER.logExceptionAsWarning(new IndexOutOfBoundsException("Index out of range: " + i));
        }
        switch (i) {
            case 0: {
                return this.west;
            }
            case 1: {
                return this.south;
            }
            case 2: {
                return this.east;
            }
            case 3: {
                return this.north;
            }
        }
        throw LOGGER.logExceptionAsWarning(new IndexOutOfBoundsException("Index out of range: " + i));
    }

    public String toString() {
        return this.minAltitude != null && this.maxAltitude != null ? String.format("[%s, %s, %s, %s, %s, %s]", this.west, this.south, this.minAltitude, this.east, this.north, this.maxAltitude) : String.format("[%s, %s, %s, %s]", this.west, this.south, this.east, this.north);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartArray().writeDouble(this.west).writeDouble(this.south);
        if (this.minAltitude != null) {
            jsonWriter.writeDouble(this.minAltitude);
        }
        jsonWriter.writeDouble(this.east).writeDouble(this.north);
        if (this.maxAltitude != null) {
            jsonWriter.writeDouble(this.maxAltitude);
        }
        return jsonWriter.writeEndArray();
    }

    public static GeoBoundingBox fromJson(JsonReader jsonReader) throws IOException {
        List<Number> coordinates = jsonReader.readArray(reader -> {
            if (reader.currentToken() == JsonToken.NUMBER) {
                return reader.getDouble();
            }
            return null;
        });
        if (coordinates == null) {
            return null;
        }
        int coordinateCount = coordinates.size();
        if (coordinateCount != 4 && coordinateCount != 6) {
            throw LOGGER.logExceptionAsError(new IllegalStateException("Only 2 or 3 dimension bounding boxes are supported."));
        }
        double west = coordinates.get(0).doubleValue();
        double south = coordinates.get(1).doubleValue();
        double east = coordinates.get(coordinateCount == 6 ? 3 : 2).doubleValue();
        double north = coordinates.get(coordinateCount == 6 ? 4 : 3).doubleValue();
        Double minAltitude = coordinateCount == 6 ? Double.valueOf(coordinates.get(2).doubleValue()) : null;
        Double maxAltitude = coordinateCount == 6 ? Double.valueOf(coordinates.get(5).doubleValue()) : null;
        return new GeoBoundingBox(west, south, east, north, minAltitude, maxAltitude, null);
    }
}

