/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.core.util.paging;

import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.core.util.paging.ContinuablePage;
import com.dataiku.dss.shadelibazure.com.azure.core.util.paging.ContinuationState;
import com.dataiku.dss.shadelibazure.com.azure.core.util.paging.PageRetriever;
import com.dataiku.dss.shadelibazure.com.azure.core.util.paging.PageRetrieverSync;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicBoolean;

abstract class ContinuablePagedByIteratorBase<C, T, P extends ContinuablePage<C, T>, E>
implements Iterator<E> {
    private final PageRetriever<C, P> pageRetriever;
    private final PageRetrieverSync<C, P> pageRetrieverSync;
    private final ContinuationState<C> continuationState;
    private final Integer defaultPageSize;
    private final ClientLogger logger;
    private volatile boolean done;

    ContinuablePagedByIteratorBase(PageRetriever<C, P> pageRetriever, ContinuationState<C> continuationState, Integer defaultPageSize, ClientLogger logger) {
        this.continuationState = continuationState;
        this.pageRetriever = pageRetriever;
        this.defaultPageSize = defaultPageSize;
        this.logger = logger;
        this.pageRetrieverSync = null;
    }

    ContinuablePagedByIteratorBase(PageRetrieverSync<C, P> pageRetrieverSync, ContinuationState<C> continuationState, Integer defaultPageSize, ClientLogger logger) {
        this.continuationState = continuationState;
        this.pageRetrieverSync = pageRetrieverSync;
        this.defaultPageSize = defaultPageSize;
        this.logger = logger;
        this.pageRetriever = null;
    }

    @Override
    public E next() {
        if (!this.hasNext()) {
            throw this.logger.logExceptionAsError(new NoSuchElementException("Iterator contains no more elements."));
        }
        return this.getNext();
    }

    @Override
    public boolean hasNext() {
        while (!this.done && this.needToRequestPage()) {
            this.requestPage();
        }
        return this.isNextAvailable();
    }

    abstract boolean needToRequestPage();

    abstract boolean isNextAvailable();

    abstract E getNext();

    synchronized void requestPage() {
        ContinuablePage page2;
        AtomicBoolean receivedPages = new AtomicBoolean(false);
        if (this.pageRetriever != null) {
            if (this.isNextAvailable() || this.done) {
                return;
            }
            this.pageRetriever.get(this.continuationState.getLastContinuationToken(), this.defaultPageSize).map(page -> {
                this.receivePage(receivedPages, page);
                return page;
            }).blockLast();
        } else if (this.pageRetrieverSync != null && (page2 = (ContinuablePage)this.pageRetrieverSync.getPage(this.continuationState.getLastContinuationToken(), this.defaultPageSize)) != null) {
            this.receivePage(receivedPages, page2);
        }
        this.done = this.done || !receivedPages.get() && !this.isNextAvailable();
    }

    abstract void addPage(P var1);

    private void receivePage(AtomicBoolean receivedPages, P page) {
        receivedPages.set(true);
        this.addPage(page);
        this.continuationState.setLastContinuationToken(page.getContinuationToken());
        this.done = this.continuationState.isDone();
    }
}

