/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.identity;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.core.util.logging.ClientLogger;
import com.dataiku.dss.shadelibazure.com.azure.identity.AadCredentialBuilderBase;
import com.dataiku.dss.shadelibazure.com.azure.identity.WorkloadIdentityCredential;
import com.dataiku.dss.shadelibazure.com.azure.identity.implementation.util.ValidationUtil;

public class WorkloadIdentityCredentialBuilder
extends AadCredentialBuilderBase<WorkloadIdentityCredentialBuilder> {
    private static final ClientLogger LOGGER = new ClientLogger(WorkloadIdentityCredentialBuilder.class);
    private String tokenFilePath;

    public WorkloadIdentityCredentialBuilder tokenFilePath(String tokenFilePath) {
        this.tokenFilePath = tokenFilePath;
        return this;
    }

    public WorkloadIdentityCredential build() {
        Configuration configuration = this.identityClientOptions.getConfiguration() == null ? Configuration.getGlobalConfiguration().clone() : this.identityClientOptions.getConfiguration();
        String tenantIdInput = CoreUtils.isNullOrEmpty(this.tenantId) ? configuration.get("AZURE_TENANT_ID") : this.tenantId;
        String federatedTokenFilePathInput = CoreUtils.isNullOrEmpty(this.tokenFilePath) ? configuration.get("AZURE_FEDERATED_TOKEN_FILE") : this.tokenFilePath;
        String clientIdInput = CoreUtils.isNullOrEmpty(this.clientId) ? configuration.get("AZURE_CLIENT_ID") : this.clientId;
        ValidationUtil.validate(this.getClass().getSimpleName(), LOGGER, "Client ID", clientIdInput, "Tenant ID", tenantIdInput, "Service Token File Path", federatedTokenFilePathInput);
        return new WorkloadIdentityCredential(tenantIdInput, clientIdInput, federatedTokenFilePathInput, this.identityClientOptions.clone());
    }
}

