/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildResultProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.BuildStageProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appplatform.models.Error;
import java.io.IOException;
import java.util.List;

public final class BuildResultProperties
implements JsonSerializable<BuildResultProperties> {
    private String name;
    private BuildResultProvisioningState provisioningState;
    private Error error;
    private String buildPodName;
    private List<BuildStageProperties> buildStages;
    private String image;

    public String name() {
        return this.name;
    }

    public BuildResultProperties withName(String name) {
        this.name = name;
        return this;
    }

    public BuildResultProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public Error error() {
        return this.error;
    }

    public BuildResultProperties withError(Error error) {
        this.error = error;
        return this;
    }

    public String buildPodName() {
        return this.buildPodName;
    }

    public BuildResultProperties withBuildPodName(String buildPodName) {
        this.buildPodName = buildPodName;
        return this;
    }

    public List<BuildStageProperties> buildStages() {
        return this.buildStages;
    }

    public String image() {
        return this.image;
    }

    public void validate() {
        if (this.error() != null) {
            this.error().validate();
        }
        if (this.buildStages() != null) {
            this.buildStages().forEach(e -> e.validate());
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeJsonField("error", this.error);
        jsonWriter.writeStringField("buildPodName", this.buildPodName);
        return jsonWriter.writeEndObject();
    }

    public static BuildResultProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BuildResultProperties deserializedBuildResultProperties = new BuildResultProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    deserializedBuildResultProperties.name = reader.getString();
                    continue;
                }
                if ("provisioningState".equals(fieldName)) {
                    deserializedBuildResultProperties.provisioningState = BuildResultProvisioningState.fromString(reader.getString());
                    continue;
                }
                if ("error".equals(fieldName)) {
                    deserializedBuildResultProperties.error = Error.fromJson(reader);
                    continue;
                }
                if ("buildPodName".equals(fieldName)) {
                    deserializedBuildResultProperties.buildPodName = reader.getString();
                    continue;
                }
                if ("buildStages".equals(fieldName)) {
                    List<BuildStageProperties> buildStages = reader.readArray(reader1 -> BuildStageProperties.fromJson(reader1));
                    deserializedBuildResultProperties.buildStages = buildStages;
                    continue;
                }
                if ("image".equals(fieldName)) {
                    deserializedBuildResultProperties.image = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedBuildResultProperties;
        });
    }
}

