/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.ContainerAppProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Configuration;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.ContainerAppProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Template;
import java.io.IOException;
import java.util.Map;

public final class ContainerAppInner
extends Resource {
    private ContainerAppProperties innerProperties;
    private String kind;
    private String type;
    private String name;
    private String id;

    private ContainerAppProperties innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public ContainerAppInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public ContainerAppInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public ContainerAppInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public ContainerAppProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String kubeEnvironmentId() {
        return this.innerProperties() == null ? null : this.innerProperties().kubeEnvironmentId();
    }

    public ContainerAppInner withKubeEnvironmentId(String kubeEnvironmentId) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withKubeEnvironmentId(kubeEnvironmentId);
        return this;
    }

    public String latestRevisionName() {
        return this.innerProperties() == null ? null : this.innerProperties().latestRevisionName();
    }

    public String latestRevisionFqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().latestRevisionFqdn();
    }

    public Configuration configuration() {
        return this.innerProperties() == null ? null : this.innerProperties().configuration();
    }

    public ContainerAppInner withConfiguration(Configuration configuration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withConfiguration(configuration);
        return this;
    }

    public Template template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public ContainerAppInner withTemplate(Template template) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ContainerAppProperties();
        }
        this.innerProperties().withTemplate(template);
        return this;
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static ContainerAppInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ContainerAppInner deserializedContainerAppInner = new ContainerAppInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedContainerAppInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedContainerAppInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedContainerAppInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedContainerAppInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedContainerAppInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedContainerAppInner.innerProperties = ContainerAppProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedContainerAppInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedContainerAppInner;
        });
    }
}

