/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.management.Resource;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models.RevisionProperties;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RevisionHealthState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.RevisionProvisioningState;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.Template;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

public final class RevisionInner
extends Resource {
    private RevisionProperties innerProperties;
    private String kind;
    private String type;
    private String name;
    private String id;

    private RevisionProperties innerProperties() {
        return this.innerProperties;
    }

    public String kind() {
        return this.kind;
    }

    public RevisionInner withKind(String kind) {
        this.kind = kind;
        return this;
    }

    @Override
    public String type() {
        return this.type;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String id() {
        return this.id;
    }

    @Override
    public RevisionInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    @Override
    public RevisionInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public OffsetDateTime createdTime() {
        return this.innerProperties() == null ? null : this.innerProperties().createdTime();
    }

    public String fqdn() {
        return this.innerProperties() == null ? null : this.innerProperties().fqdn();
    }

    public Template template() {
        return this.innerProperties() == null ? null : this.innerProperties().template();
    }

    public Boolean active() {
        return this.innerProperties() == null ? null : this.innerProperties().active();
    }

    public Integer replicas() {
        return this.innerProperties() == null ? null : this.innerProperties().replicas();
    }

    public Integer trafficWeight() {
        return this.innerProperties() == null ? null : this.innerProperties().trafficWeight();
    }

    public String provisioningError() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningError();
    }

    public RevisionHealthState healthState() {
        return this.innerProperties() == null ? null : this.innerProperties().healthState();
    }

    public RevisionProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public void validate() {
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("location", this.location());
        jsonWriter.writeMapField("tags", this.tags(), (writer, element) -> writer.writeString((String)element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeStringField("kind", this.kind);
        return jsonWriter.writeEndObject();
    }

    public static RevisionInner fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            RevisionInner deserializedRevisionInner = new RevisionInner();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedRevisionInner.id = reader.getString();
                    continue;
                }
                if ("name".equals(fieldName)) {
                    deserializedRevisionInner.name = reader.getString();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    deserializedRevisionInner.type = reader.getString();
                    continue;
                }
                if ("location".equals(fieldName)) {
                    deserializedRevisionInner.withLocation(reader.getString());
                    continue;
                }
                if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedRevisionInner.withTags((Map)tags);
                    continue;
                }
                if ("properties".equals(fieldName)) {
                    deserializedRevisionInner.innerProperties = RevisionProperties.fromJson(reader);
                    continue;
                }
                if ("kind".equals(fieldName)) {
                    deserializedRevisionInner.kind = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedRevisionInner;
        });
    }
}

