/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.SnapshotRecoverySource;
import java.io.IOException;

public final class SnapshotRestoreRequestProperties
implements JsonSerializable<SnapshotRestoreRequestProperties> {
    private String snapshotTime;
    private SnapshotRecoverySource recoverySource;
    private boolean overwrite;
    private Boolean recoverConfiguration;
    private Boolean ignoreConflictingHostNames;
    private Boolean useDRSecondary;

    public String snapshotTime() {
        return this.snapshotTime;
    }

    public SnapshotRestoreRequestProperties withSnapshotTime(String snapshotTime) {
        this.snapshotTime = snapshotTime;
        return this;
    }

    public SnapshotRecoverySource recoverySource() {
        return this.recoverySource;
    }

    public SnapshotRestoreRequestProperties withRecoverySource(SnapshotRecoverySource recoverySource) {
        this.recoverySource = recoverySource;
        return this;
    }

    public boolean overwrite() {
        return this.overwrite;
    }

    public SnapshotRestoreRequestProperties withOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
        return this;
    }

    public Boolean recoverConfiguration() {
        return this.recoverConfiguration;
    }

    public SnapshotRestoreRequestProperties withRecoverConfiguration(Boolean recoverConfiguration) {
        this.recoverConfiguration = recoverConfiguration;
        return this;
    }

    public Boolean ignoreConflictingHostNames() {
        return this.ignoreConflictingHostNames;
    }

    public SnapshotRestoreRequestProperties withIgnoreConflictingHostNames(Boolean ignoreConflictingHostNames) {
        this.ignoreConflictingHostNames = ignoreConflictingHostNames;
        return this;
    }

    public Boolean useDRSecondary() {
        return this.useDRSecondary;
    }

    public SnapshotRestoreRequestProperties withUseDRSecondary(Boolean useDRSecondary) {
        this.useDRSecondary = useDRSecondary;
        return this;
    }

    public void validate() {
        if (this.recoverySource() != null) {
            this.recoverySource().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeBooleanField("overwrite", this.overwrite);
        jsonWriter.writeStringField("snapshotTime", this.snapshotTime);
        jsonWriter.writeJsonField("recoverySource", this.recoverySource);
        jsonWriter.writeBooleanField("recoverConfiguration", this.recoverConfiguration);
        jsonWriter.writeBooleanField("ignoreConflictingHostNames", this.ignoreConflictingHostNames);
        jsonWriter.writeBooleanField("useDRSecondary", this.useDRSecondary);
        return jsonWriter.writeEndObject();
    }

    public static SnapshotRestoreRequestProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            SnapshotRestoreRequestProperties deserializedSnapshotRestoreRequestProperties = new SnapshotRestoreRequestProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("overwrite".equals(fieldName)) {
                    deserializedSnapshotRestoreRequestProperties.overwrite = reader.getBoolean();
                    continue;
                }
                if ("snapshotTime".equals(fieldName)) {
                    deserializedSnapshotRestoreRequestProperties.snapshotTime = reader.getString();
                    continue;
                }
                if ("recoverySource".equals(fieldName)) {
                    deserializedSnapshotRestoreRequestProperties.recoverySource = SnapshotRecoverySource.fromJson(reader);
                    continue;
                }
                if ("recoverConfiguration".equals(fieldName)) {
                    deserializedSnapshotRestoreRequestProperties.recoverConfiguration = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("ignoreConflictingHostNames".equals(fieldName)) {
                    deserializedSnapshotRestoreRequestProperties.ignoreConflictingHostNames = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("useDRSecondary".equals(fieldName)) {
                    deserializedSnapshotRestoreRequestProperties.useDRSecondary = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedSnapshotRestoreRequestProperties;
        });
    }
}

