/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonSerializable;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.AppInsightsWebAppStackSettings;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.appservice.models.GitHubActionWebAppStackSettings;
import java.io.IOException;
import java.time.OffsetDateTime;

public final class WebAppRuntimeSettings
implements JsonSerializable<WebAppRuntimeSettings> {
    private String runtimeVersion;
    private Boolean remoteDebuggingSupported;
    private AppInsightsWebAppStackSettings appInsightsSettings;
    private GitHubActionWebAppStackSettings gitHubActionSettings;
    private Boolean isPreview;
    private Boolean isDeprecated;
    private Boolean isHidden;
    private OffsetDateTime endOfLifeDate;
    private Boolean isAutoUpdate;
    private Boolean isEarlyAccess;

    public String runtimeVersion() {
        return this.runtimeVersion;
    }

    public Boolean remoteDebuggingSupported() {
        return this.remoteDebuggingSupported;
    }

    public AppInsightsWebAppStackSettings appInsightsSettings() {
        return this.appInsightsSettings;
    }

    public GitHubActionWebAppStackSettings gitHubActionSettings() {
        return this.gitHubActionSettings;
    }

    public Boolean isPreview() {
        return this.isPreview;
    }

    public Boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Boolean isHidden() {
        return this.isHidden;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public Boolean isAutoUpdate() {
        return this.isAutoUpdate;
    }

    public Boolean isEarlyAccess() {
        return this.isEarlyAccess;
    }

    public void validate() {
        if (this.appInsightsSettings() != null) {
            this.appInsightsSettings().validate();
        }
        if (this.gitHubActionSettings() != null) {
            this.gitHubActionSettings().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    public static WebAppRuntimeSettings fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            WebAppRuntimeSettings deserializedWebAppRuntimeSettings = new WebAppRuntimeSettings();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("runtimeVersion".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.runtimeVersion = reader.getString();
                    continue;
                }
                if ("remoteDebuggingSupported".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.remoteDebuggingSupported = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("appInsightsSettings".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.appInsightsSettings = AppInsightsWebAppStackSettings.fromJson(reader);
                    continue;
                }
                if ("gitHubActionSettings".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.gitHubActionSettings = GitHubActionWebAppStackSettings.fromJson(reader);
                    continue;
                }
                if ("isPreview".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.isPreview = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isDeprecated".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.isDeprecated = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isHidden".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.isHidden = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("endOfLifeDate".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.endOfLifeDate = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("isAutoUpdate".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.isAutoUpdate = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("isEarlyAccess".equals(fieldName)) {
                    deserializedWebAppRuntimeSettings.isEarlyAccess = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedWebAppRuntimeSettings;
        });
    }
}

