/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.Base64Url;
import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphBaseItemVersion;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphPublicationFacet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;

public final class MicrosoftGraphDriveItemVersion
extends MicrosoftGraphBaseItemVersion {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private Base64Url content;
    private Long size;
    private Map<String, Object> additionalProperties;

    public byte[] content() {
        if (this.content == null) {
            return EMPTY_BYTE_ARRAY;
        }
        return this.content.decodedBytes();
    }

    public MicrosoftGraphDriveItemVersion withContent(byte[] content) {
        this.content = content == null ? null : Base64Url.encode(CoreUtils.clone(content));
        return this;
    }

    public Long size() {
        return this.size;
    }

    public MicrosoftGraphDriveItemVersion withSize(Long size) {
        this.size = size;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphDriveItemVersion withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphDriveItemVersion withLastModifiedBy(MicrosoftGraphIdentitySet lastModifiedBy) {
        super.withLastModifiedBy(lastModifiedBy);
        return this;
    }

    @Override
    public MicrosoftGraphDriveItemVersion withLastModifiedDateTime(OffsetDateTime lastModifiedDateTime) {
        super.withLastModifiedDateTime(lastModifiedDateTime);
        return this;
    }

    @Override
    public MicrosoftGraphDriveItemVersion withPublication(MicrosoftGraphPublicationFacet publication) {
        super.withPublication(publication);
        return this;
    }

    @Override
    public MicrosoftGraphDriveItemVersion withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeJsonField("lastModifiedBy", this.lastModifiedBy());
        jsonWriter.writeStringField("lastModifiedDateTime", this.lastModifiedDateTime() == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.lastModifiedDateTime()));
        jsonWriter.writeJsonField("publication", this.publication());
        jsonWriter.writeStringField("content", Objects.toString(this.content, null));
        jsonWriter.writeNumberField("size", this.size);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphDriveItemVersion fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphDriveItemVersion deserializedMicrosoftGraphDriveItemVersion = new MicrosoftGraphDriveItemVersion();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.withId(reader.getString());
                    continue;
                }
                if ("lastModifiedBy".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.withLastModifiedBy(MicrosoftGraphIdentitySet.fromJson(reader));
                    continue;
                }
                if ("lastModifiedDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.withLastModifiedDateTime(reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString())));
                    continue;
                }
                if ("publication".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.withPublication(MicrosoftGraphPublicationFacet.fromJson(reader));
                    continue;
                }
                if ("content".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.content = reader.getNullable(nonNullReader -> new Base64Url(nonNullReader.getString()));
                    continue;
                }
                if ("size".equals(fieldName)) {
                    deserializedMicrosoftGraphDriveItemVersion.size = reader.getNullable(JsonReader::getLong);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphDriveItemVersion.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphDriveItemVersion;
        });
    }
}

