/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models;

import com.dataiku.dss.shadelibazure.com.azure.core.util.CoreUtils;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonReader;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonToken;
import com.dataiku.dss.shadelibazure.com.azure.json.JsonWriter;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphDriveItem;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphEntity;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphIdentitySet;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public final class MicrosoftGraphItemActivity
extends MicrosoftGraphEntity {
    private Map<String, Object> access;
    private OffsetDateTime activityDateTime;
    private MicrosoftGraphIdentitySet actor;
    private MicrosoftGraphDriveItem driveItem;
    private Map<String, Object> additionalProperties;

    public Map<String, Object> access() {
        return this.access;
    }

    public MicrosoftGraphItemActivity withAccess(Map<String, Object> access) {
        this.access = access;
        return this;
    }

    public OffsetDateTime activityDateTime() {
        return this.activityDateTime;
    }

    public MicrosoftGraphItemActivity withActivityDateTime(OffsetDateTime activityDateTime) {
        this.activityDateTime = activityDateTime;
        return this;
    }

    public MicrosoftGraphIdentitySet actor() {
        return this.actor;
    }

    public MicrosoftGraphItemActivity withActor(MicrosoftGraphIdentitySet actor) {
        this.actor = actor;
        return this;
    }

    public MicrosoftGraphDriveItem driveItem() {
        return this.driveItem;
    }

    public MicrosoftGraphItemActivity withDriveItem(MicrosoftGraphDriveItem driveItem) {
        this.driveItem = driveItem;
        return this;
    }

    @Override
    public Map<String, Object> additionalProperties() {
        return this.additionalProperties;
    }

    @Override
    public MicrosoftGraphItemActivity withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    @Override
    public MicrosoftGraphItemActivity withId(String id) {
        super.withId(id);
        return this;
    }

    @Override
    public void validate() {
        super.validate();
        if (this.actor() != null) {
            this.actor().validate();
        }
        if (this.driveItem() != null) {
            this.driveItem().validate();
        }
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id());
        jsonWriter.writeMapField("access", this.access, (writer, element) -> writer.writeUntyped(element));
        jsonWriter.writeStringField("activityDateTime", this.activityDateTime == null ? null : DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(this.activityDateTime));
        jsonWriter.writeJsonField("actor", this.actor);
        jsonWriter.writeJsonField("driveItem", this.driveItem);
        if (this.additionalProperties != null) {
            for (Map.Entry<String, Object> additionalProperty : this.additionalProperties.entrySet()) {
                jsonWriter.writeUntypedField(additionalProperty.getKey(), additionalProperty.getValue());
            }
        }
        return jsonWriter.writeEndObject();
    }

    public static MicrosoftGraphItemActivity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            MicrosoftGraphItemActivity deserializedMicrosoftGraphItemActivity = new MicrosoftGraphItemActivity();
            LinkedHashMap<String, Object> additionalProperties = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.withId(reader.getString());
                    continue;
                }
                if ("access".equals(fieldName)) {
                    Map<String, Object> access = reader.readMap(reader1 -> reader1.readUntyped());
                    deserializedMicrosoftGraphItemActivity.access = access;
                    continue;
                }
                if ("activityDateTime".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.activityDateTime = reader.getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                    continue;
                }
                if ("actor".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.actor = MicrosoftGraphIdentitySet.fromJson(reader);
                    continue;
                }
                if ("driveItem".equals(fieldName)) {
                    deserializedMicrosoftGraphItemActivity.driveItem = MicrosoftGraphDriveItem.fromJson(reader);
                    continue;
                }
                if (additionalProperties == null) {
                    additionalProperties = new LinkedHashMap<String, Object>();
                }
                additionalProperties.put(fieldName, reader.readUntyped());
            }
            deserializedMicrosoftGraphItemActivity.additionalProperties = additionalProperties;
            return deserializedMicrosoftGraphItemActivity;
        });
    }
}

