/*
 * Decompiled with CFR 0.152.
 */
package com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation;

import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedFlux;
import com.dataiku.dss.shadelibazure.com.azure.core.http.rest.PagedIterable;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.AuthorizationManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.ApplicationsApplicationsClient;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.fluent.models.MicrosoftGraphApplicationInner;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.implementation.ActiveDirectoryApplicationImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryApplication;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.authorization.models.ActiveDirectoryApplications;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.collection.implementation.CreatableResourcesImpl;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.arm.models.HasManager;
import com.dataiku.dss.shadelibazure.com.azure.resourcemanager.resources.fluentcore.utils.PagedConverter;
import com.dataiku.dss.shadelibazure.reactor.core.publisher.Mono;
import java.util.UUID;

public class ActiveDirectoryApplicationsImpl
extends CreatableResourcesImpl<ActiveDirectoryApplication, ActiveDirectoryApplicationImpl, MicrosoftGraphApplicationInner>
implements ActiveDirectoryApplications,
HasManager<AuthorizationManager> {
    private AuthorizationManager manager;

    public ActiveDirectoryApplicationsImpl(AuthorizationManager authorizationManager) {
        this.manager = authorizationManager;
    }

    @Override
    public PagedIterable<ActiveDirectoryApplication> list() {
        return new PagedIterable<ActiveDirectoryApplication>(this.listAsync());
    }

    @Override
    public PagedFlux<ActiveDirectoryApplication> listAsync() {
        return PagedConverter.mapPage(this.inner().listApplicationAsync(), this::wrapModel);
    }

    @Override
    protected ActiveDirectoryApplicationImpl wrapModel(MicrosoftGraphApplicationInner applicationInner) {
        if (applicationInner == null) {
            return null;
        }
        return new ActiveDirectoryApplicationImpl(applicationInner, this.manager());
    }

    @Override
    public ActiveDirectoryApplicationImpl getById(String id) {
        return (ActiveDirectoryApplicationImpl)this.getByIdAsync(id).block();
    }

    @Override
    public Mono<ActiveDirectoryApplication> getByIdAsync(String id) {
        return this.inner().getApplicationAsync(id).map(this::wrapModel);
    }

    @Override
    public ActiveDirectoryApplication getByName(String spn) {
        return this.getByNameAsync(spn).block();
    }

    @Override
    public Mono<ActiveDirectoryApplication> getByNameAsync(String name) {
        String trimmed = name.replaceFirst("^'+", "").replaceAll("'+$", "");
        return this.listByFilterAsync(String.format("displayName eq '%s'", trimmed)).singleOrEmpty().switchIfEmpty(Mono.defer(() -> {
            try {
                UUID.fromString(trimmed);
            }
            catch (IllegalArgumentException e) {
                return Mono.empty();
            }
            return this.listByFilterAsync(String.format("appId eq '%s'", trimmed)).singleOrEmpty();
        }));
    }

    @Override
    protected ActiveDirectoryApplicationImpl wrapModel(String name) {
        return new ActiveDirectoryApplicationImpl(new MicrosoftGraphApplicationInner().withDisplayName(name), this.manager());
    }

    @Override
    public Mono<Void> deleteByIdAsync(String id) {
        return this.inner().deleteApplicationAsync(id);
    }

    @Override
    public ActiveDirectoryApplicationImpl define(String name) {
        return this.wrapModel(name);
    }

    @Override
    public AuthorizationManager manager() {
        return this.manager;
    }

    public ApplicationsApplicationsClient inner() {
        return this.manager().serviceClient().getApplicationsApplications();
    }

    @Override
    public PagedIterable<ActiveDirectoryApplication> listByFilter(String filter) {
        return new PagedIterable<ActiveDirectoryApplication>(this.listByFilterAsync(filter));
    }

    @Override
    public PagedFlux<ActiveDirectoryApplication> listByFilterAsync(String filter) {
        return PagedConverter.mapPage(this.inner().listApplicationAsync(null, null, null, null, filter, null, null, null, null), this::wrapModel);
    }
}

